/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.opera;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriverException;

public class OperaOptions
extends MutableCapabilities {
    public static final String CAPABILITY = "operaOptions";
    private String binary;
    private List<String> args = Lists.newArrayList();
    private List<File> extensionFiles = Lists.newArrayList();
    private List<String> extensions = Lists.newArrayList();
    private Map<String, Object> experimentalOptions = Maps.newHashMap();

    public OperaOptions() {
        this.setCapability("browserName", "operablink");
    }

    public OperaOptions setBinary(File path) {
        this.binary = ((File)Preconditions.checkNotNull((Object)path)).getPath();
        return this;
    }

    public OperaOptions setBinary(String path) {
        this.binary = (String)Preconditions.checkNotNull((Object)path);
        return this;
    }

    public OperaOptions addArguments(String ... arguments) {
        this.addArguments((List<String>)ImmutableList.copyOf((Object[])arguments));
        return this;
    }

    public OperaOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public OperaOptions addExtensions(File ... paths) {
        this.addExtensions((List<File>)ImmutableList.copyOf((Object[])paths));
        return this;
    }

    public OperaOptions addExtensions(List<File> paths) {
        for (File path : paths) {
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkArgument((boolean)path.exists(), (String)"%s does not exist", (Object)path.getAbsolutePath());
            Preconditions.checkArgument((!path.isDirectory() ? 1 : 0) != 0, (String)"%s is a directory", (Object)path.getAbsolutePath());
        }
        this.extensionFiles.addAll(paths);
        return this;
    }

    public OperaOptions addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions((List<String>)ImmutableList.copyOf((Object[])encoded));
        return this;
    }

    public OperaOptions addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Preconditions.checkNotNull((Object)extension);
        }
        this.extensions.addAll(encoded);
        return this;
    }

    public OperaOptions setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put((String)Preconditions.checkNotNull((Object)name), value);
        return this;
    }

    public Object getExperimentalOption(String name) {
        return this.experimentalOptions.get(Preconditions.checkNotNull((Object)name));
    }

    public Map<String, ?> asMap() {
        TreeMap toReturn = new TreeMap();
        toReturn.putAll(super.asMap());
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        for (String key : this.experimentalOptions.keySet()) {
            options.put(key, this.experimentalOptions.get(key));
        }
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", ImmutableList.copyOf(this.args));
        ArrayList encoded_extensions = Lists.newArrayListWithExpectedSize((int)(this.extensionFiles.size() + this.extensions.size()));
        for (File path : this.extensionFiles) {
            try {
                String encoded = Base64.getEncoder().encodeToString(Files.toByteArray((File)path));
                encoded_extensions.add(encoded);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        encoded_extensions.addAll(this.extensions);
        options.put("extensions", encoded_extensions);
        toReturn.put(CAPABILITY, options);
        return Collections.unmodifiableMap(toReturn);
    }
}

