/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.opera;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.Browser;

public class OperaOptions
extends AbstractDriverOptions<OperaOptions> {
    public static final String CAPABILITY = "operaOptions";
    private String binary;
    private List<String> args = new ArrayList<String>();
    private List<File> extensionFiles = new ArrayList<File>();
    private List<String> extensions = new ArrayList<String>();
    private Map<String, Object> experimentalOptions = new HashMap<String, Object>();

    public OperaOptions() {
        this.setCapability("browserName", Browser.OPERA.browserName());
    }

    public OperaOptions merge(Capabilities extraCapabilities) {
        OperaOptions newInstance = new OperaOptions();
        this.asMap().forEach((arg_0, arg_1) -> ((OperaOptions)newInstance).setCapability(arg_0, arg_1));
        extraCapabilities.asMap().forEach((arg_0, arg_1) -> ((OperaOptions)newInstance).setCapability(arg_0, arg_1));
        return newInstance;
    }

    public OperaOptions setBinary(File path) {
        this.binary = ((File)Require.nonNull((String)"Path to the opera executable", (Object)path)).getPath();
        return this;
    }

    public OperaOptions setBinary(String path) {
        this.binary = (String)Require.nonNull((String)"Path to the opera executable", (Object)path);
        return this;
    }

    public OperaOptions addArguments(String ... arguments) {
        this.addArguments(Arrays.asList(arguments));
        return this;
    }

    public OperaOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public OperaOptions addExtensions(File ... paths) {
        this.addExtensions(Arrays.asList(paths));
        return this;
    }

    public OperaOptions addExtensions(List<File> paths) {
        paths.forEach(path -> Require.argument((String)"Extension", (File)path).isFile());
        this.extensionFiles.addAll(paths);
        return this;
    }

    public OperaOptions addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions(Arrays.asList(encoded));
        return this;
    }

    public OperaOptions addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Require.nonNull((String)"Encoded exception", (Object)extension);
        }
        this.extensions.addAll(encoded);
        return this;
    }

    public OperaOptions setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put((String)Require.nonNull((String)"Option name", (Object)name), value);
        return this;
    }

    public Object getExperimentalOption(String name) {
        return this.experimentalOptions.get(Require.nonNull((String)"Option name", (Object)name));
    }

    protected Set<String> getExtraCapabilityNames() {
        return Collections.singleton(CAPABILITY);
    }

    protected Object getExtraCapability(String capabilityName) {
        Require.nonNull((String)"Capability name", (Object)capabilityName);
        if (!CAPABILITY.equals(capabilityName)) {
            return null;
        }
        TreeMap<String, Object> options = new TreeMap<String, Object>(this.experimentalOptions);
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", Collections.unmodifiableList(new ArrayList<String>(this.args)));
        ArrayList<String> encodedExtensions = new ArrayList<String>();
        for (File file : this.extensionFiles) {
            try {
                String encoded = Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
                encodedExtensions.add(encoded);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        encodedExtensions.addAll(this.extensions);
        options.put("extensions", Collections.unmodifiableList(encodedExtensions));
        return Collections.unmodifiableMap(options);
    }
}

