/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesiredCapabilities
implements Serializable,
Capabilities {
    private final Map<String, Object> capabilities = new HashMap<String, Object>();

    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.setCapability("browserName", browser);
        this.setCapability("version", version);
        this.setCapability("platform", platform);
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, ?> rawMap) {
        this.capabilities.putAll(rawMap);
        Object value = this.capabilities.get("platform");
        if (value instanceof String) {
            this.capabilities.put("platform", Platform.valueOf((String)((String)value)));
        }
    }

    public DesiredCapabilities(Capabilities other) {
        if (other != null) {
            this.capabilities.putAll(other.asMap());
        }
    }

    public String getBrowserName() {
        return (String)this.capabilities.get("browserName");
    }

    public void setBrowserName(String browserName) {
        this.setCapability("browserName", browserName);
    }

    public String getVersion() {
        return (String)this.capabilities.get("version");
    }

    public void setVersion(String version) {
        this.setCapability("version", version);
    }

    public Platform getPlatform() {
        if (this.capabilities.containsKey("platform")) {
            Object raw = this.capabilities.get("platform");
            if (raw instanceof String) {
                return Platform.valueOf((String)((String)raw));
            }
            if (raw instanceof Platform) {
                return (Platform)raw;
            }
        }
        return null;
    }

    public void setPlatform(Platform platform) {
        this.setCapability("platform", platform);
    }

    public boolean isJavascriptEnabled() {
        if (this.capabilities.containsKey("javascriptEnabled")) {
            Object raw = this.capabilities.get("javascriptEnabled");
            if (raw instanceof String) {
                return Boolean.parseBoolean((String)raw);
            }
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
        }
        return true;
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.setCapability("javascriptEnabled", javascriptEnabled);
    }

    public Object getCapability(String capabilityName) {
        return this.capabilities.get(capabilityName);
    }

    public boolean is(String capabilityName) {
        Object cap = this.getCapability(capabilityName);
        if (cap == null) {
            return false;
        }
        return cap instanceof Boolean ? (Boolean)cap : Boolean.parseBoolean(String.valueOf(cap));
    }

    public void merge(Capabilities extraCapabilities) {
        this.capabilities.putAll(extraCapabilities.asMap());
    }

    public void setCapability(String capabilityName, boolean value) {
        this.capabilities.put(capabilityName, value);
    }

    public void setCapability(String capabilityName, String value) {
        this.capabilities.put(capabilityName, value);
    }

    public void setCapability(String capabilityName, Platform value) {
        this.capabilities.put(capabilityName, value);
    }

    public Map<String, ?> asMap() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public void setCapability(String key, Object value) {
        this.capabilities.put(key, value);
    }

    public static DesiredCapabilities firefox() {
        return new DesiredCapabilities("firefox", "", Platform.ANY);
    }

    public static DesiredCapabilities internetExplorer() {
        DesiredCapabilities capabilities = new DesiredCapabilities("internet explorer", "", Platform.WINDOWS);
        capabilities.setCapability("ensureCleanSession", true);
        return capabilities;
    }

    public static DesiredCapabilities htmlUnit() {
        return new DesiredCapabilities("htmlunit", "", Platform.ANY);
    }

    public static DesiredCapabilities iphone() {
        return new DesiredCapabilities("iphone", "", Platform.MAC);
    }

    public static DesiredCapabilities chrome() {
        return new DesiredCapabilities("chrome", "", Platform.ANY);
    }

    public static DesiredCapabilities android() {
        return new DesiredCapabilities("android", "", Platform.ANDROID);
    }

    public String toString() {
        return String.format("Capabilities [%s]", this.capabilities);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesiredCapabilities)) {
            return false;
        }
        DesiredCapabilities that = (DesiredCapabilities)o;
        return ((Object)this.capabilities).equals(that.capabilities);
    }

    public int hashCode() {
        return ((Object)this.capabilities).hashCode();
    }
}

