/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.XPathLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorCodes {
    public static final int SUCCESS = 0;
    public static final int NO_SUCH_ELEMENT = 7;
    public static final int NO_SUCH_FRAME = 8;
    public static final int UNKNOWN_COMMAND = 9;
    public static final int STALE_ELEMENT_REFERENCE = 10;
    public static final int ELEMENT_NOT_VISIBLE = 11;
    public static final int INVALID_ELEMENT_STATE = 12;
    public static final int UNHANDLED_ERROR = 13;
    public static final int ELEMENT_NOT_SELECTABLE = 15;
    public static final int XPATH_LOOKUP_ERROR = 19;
    public static final int NO_SUCH_WINDOW = 23;
    public static final int INVALID_COOKIE_DOMAIN = 24;
    public static final int UNABLE_TO_SET_COOKIE = 25;
    public static final int ASYNC_SCRIPT_TIMEOUT = 28;
    public static final int METHOD_NOT_ALLOWED = 405;

    public Class<? extends RuntimeException> getExceptionType(int statusCode) {
        switch (statusCode) {
            case 0: {
                return null;
            }
            case 24: {
                return InvalidCookieDomainException.class;
            }
            case 25: {
                return UnableToSetCookieException.class;
            }
            case 23: {
                return NoSuchWindowException.class;
            }
            case 7: {
                return NoSuchElementException.class;
            }
            case 8: {
                return NoSuchFrameException.class;
            }
            case 9: 
            case 405: {
                return UnsupportedOperationException.class;
            }
            case 10: {
                return StaleElementReferenceException.class;
            }
            case 11: {
                return ElementNotVisibleException.class;
            }
            case 12: 
            case 15: {
                return UnsupportedOperationException.class;
            }
            case 19: {
                return XPathLookupException.class;
            }
            case 28: {
                return TimeoutException.class;
            }
        }
        return WebDriverException.class;
    }

    public int toStatusCode(Throwable thrown) {
        if (thrown == null) {
            return 0;
        }
        if (thrown instanceof InvalidCookieDomainException) {
            return 24;
        }
        if (thrown instanceof UnableToSetCookieException) {
            return 25;
        }
        if (thrown instanceof NoSuchWindowException) {
            return 23;
        }
        if (thrown instanceof NoSuchElementException) {
            return 7;
        }
        if (thrown instanceof NoSuchFrameException) {
            return 8;
        }
        if (thrown instanceof StaleElementReferenceException) {
            return 10;
        }
        if (thrown instanceof ElementNotVisibleException) {
            return 11;
        }
        if (thrown instanceof UnsupportedOperationException) {
            return 12;
        }
        if (thrown instanceof XPathLookupException) {
            return 19;
        }
        if (thrown instanceof TimeoutException) {
            return 28;
        }
        return 13;
    }

    public boolean isMappableError(Throwable thrown) {
        int statusCode = this.toStatusCode(thrown);
        return statusCode != 0 && statusCode != 13;
    }
}

