/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.thoughtworks.selenium.SeleniumException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.TimerTask;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timer {
    private java.util.Timer timer = new java.util.Timer();
    private volatile long timeout;

    public Timer(long timeout) {
        this.timeout = timeout;
    }

    public <T> T run(SeleneseCommand<T> command, WebDriver driver, String[] args) {
        Thread thread = Thread.currentThread();
        SeleneseTimerTask myTimerTask = new SeleneseTimerTask(thread);
        try {
            this.timer.schedule((TimerTask)myTimerTask, this.timeout);
        }
        catch (IllegalStateException e) {
            Thread.interrupted();
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String stack = writer.toString();
            throw new NullPointerException("Illegal attempt to execute a command after calling stop()\n" + stack);
        }
        Thread.interrupted();
        try {
            T e = command.apply(driver, args);
            return e;
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof InterruptedException) {
                throw new SeleniumException("Timed out waiting for action to finish", (Exception)re);
            }
            throw re;
        }
        finally {
            myTimerTask.cancel();
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void stop() {
        this.timer.cancel();
    }

    class SeleneseTimerTask
    extends TimerTask {
        private final Thread thread;

        SeleneseTimerTask(Thread thread) {
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.interrupt();
            }
        }
    }
}

