/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogCombiner;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingUtil;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.ExecuteMethod;

@Beta
public class RemoteLogs
implements Logs {
    private static final String LEVEL = "level";
    private static final String TIMESTAMP = "timestamp";
    private static final String MESSAGE = "message";
    protected ExecuteMethod executeMethod;
    @VisibleForTesting
    public static final String TYPE_KEY = "type";
    private final LocalLogs localLogs;

    public RemoteLogs(ExecuteMethod executeMethod, LocalLogs localLogs) {
        this.executeMethod = executeMethod;
        this.localLogs = localLogs;
    }

    public LogEntries get(String logType) {
        return LogCombiner.combine((LogEntries[])new LogEntries[]{this.getRemoteEntries(logType), this.getLocalEntries(logType)});
    }

    private LogEntries getRemoteEntries(String logType) {
        Object raw = this.executeMethod.execute("getLogs", (Map<String, ?>)ImmutableMap.of((Object)TYPE_KEY, (Object)logType));
        List rawList = (List)raw;
        ArrayList remoteEntries = Lists.newArrayListWithCapacity((int)rawList.size());
        for (Map obj : rawList) {
            remoteEntries.add(new LogEntry(LoggingUtil.toLevel((long)((Long)obj.get(LEVEL)).intValue()), ((Long)obj.get(TIMESTAMP)).longValue(), (String)obj.get(MESSAGE)));
        }
        return new LogEntries((Iterable)remoteEntries);
    }

    private LogEntries getLocalEntries(String logType) {
        return this.localLogs.get(logType);
    }
}

