/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.SimplePropertyDescriptor;

public class JsonToBeanConverter {
    public <T> T convert(Class<T> clazz, Object text) throws JsonException {
        try {
            return this.convert(clazz, text, 0);
        }
        catch (JsonSyntaxException e) {
            throw new JsonException(e, text);
        }
    }

    private <T> T convert(Class<T> clazz, Object text, int depth) {
        JsonElement json;
        if (text == null) {
            return null;
        }
        if (text instanceof JsonElement && (json = (JsonElement)text).isJsonPrimitive()) {
            JsonPrimitive jp = json.getAsJsonPrimitive();
            if (String.class.equals(clazz)) {
                return (T)jp.getAsString();
            }
            if (jp.isNumber()) {
                if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.equals(clazz)) {
                    return (T)Integer.valueOf(jp.getAsNumber().intValue());
                }
                if (Long.class.isAssignableFrom(clazz) || Long.TYPE.equals(clazz)) {
                    return (T)Long.valueOf(jp.getAsNumber().longValue());
                }
                if (Float.class.isAssignableFrom(clazz) || Float.TYPE.equals(clazz)) {
                    return (T)Float.valueOf(jp.getAsNumber().floatValue());
                }
                if (Double.class.isAssignableFrom(clazz) || Double.TYPE.equals(clazz)) {
                    return (T)Double.valueOf(jp.getAsNumber().doubleValue());
                }
                return (T)this.convertJsonPrimitive(jp);
            }
        }
        if (this.isPrimitive(text.getClass())) {
            return (T)text;
        }
        if (this.isEnum(clazz, text)) {
            return (T)this.convertEnum(clazz, text);
        }
        if ("".equals(String.valueOf(text))) {
            return (T)text;
        }
        if (Command.class.equals(clazz)) {
            json = new JsonParser().parse((String)text).getAsJsonObject();
            SessionId sessionId = null;
            if (json.has("sessionId") && !json.get("sessionId").isJsonNull()) {
                sessionId = this.convert(SessionId.class, json.get("sessionId"), depth + 1);
            }
            String name = json.get("name").getAsString();
            if (json.has("parameters")) {
                Map args = this.convert(HashMap.class, json.get("parameters"), depth + 1);
                return (T)new Command(sessionId, name, args);
            }
            return (T)new Command(sessionId, name);
        }
        if (SessionId.class.equals(clazz)) {
            Object object = json = text instanceof String ? new JsonParser().parse((String)text).getAsJsonObject() : (JsonElement)text;
            if (json.isJsonPrimitive()) {
                return (T)new SessionId(json.getAsString());
            }
            return (T)new SessionId(json.getAsJsonObject().get("value").getAsString());
        }
        if (Capabilities.class.isAssignableFrom(clazz)) {
            json = text instanceof JsonElement ? ((JsonElement)text).getAsJsonObject() : new JsonParser().parse(text.toString()).getAsJsonObject();
            Map map = this.convertMap(json.getAsJsonObject(), depth);
            return (T)new DesiredCapabilities(map);
        }
        if (Date.class.equals(clazz)) {
            return (T)new Date(Long.valueOf(String.valueOf(text)));
        }
        if (text instanceof String && !((String)text).startsWith("{") && Object.class.equals(clazz)) {
            return (T)text;
        }
        Method fromJson = this.getMethod(clazz, "fromJson");
        if (fromJson != null) {
            try {
                return (T)fromJson.invoke(null, text.toString());
            }
            catch (IllegalArgumentException e) {
                throw new WebDriverException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new WebDriverException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        if (depth == 0 && text instanceof String) {
            text = new JsonParser().parse((String)text);
        }
        if (text instanceof JsonElement) {
            JsonElement element = (JsonElement)text;
            if (element.isJsonPrimitive()) {
                return (T)this.convertJsonPrimitive(element.getAsJsonPrimitive());
            }
            if (element.isJsonArray()) {
                return (T)this.convertList(element.getAsJsonArray(), depth);
            }
            if (element.isJsonNull()) {
                return null;
            }
            if (element.isJsonObject()) {
                if (Map.class.isAssignableFrom(clazz)) {
                    return (T)this.convertMap(element.getAsJsonObject(), depth);
                }
                if (Object.class.equals(clazz)) {
                    return (T)this.convertMap(element.getAsJsonObject(), depth);
                }
                return this.convertBean(clazz, element.getAsJsonObject(), depth);
            }
        }
        return (T)text;
    }

    private Method getMethod(Class<?> clazz, String methodName) {
        try {
            return clazz.getMethod(methodName, String.class);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private Object convertJsonPrimitive(JsonElement json) {
        return this.convertJsonPrimitive(json.getAsJsonPrimitive());
    }

    private Object convertJsonPrimitive(JsonPrimitive json) {
        if (json.isBoolean()) {
            return json.getAsBoolean();
        }
        if (json.isNumber()) {
            if ((double)json.getAsLong() == json.getAsDouble()) {
                return json.getAsLong();
            }
            return json.getAsDouble();
        }
        if (json.isString()) {
            return json.getAsString();
        }
        return null;
    }

    private Enum convertEnum(Class clazz, Object text) {
        Class<?>[] allClasses;
        if (clazz.isEnum()) {
            if (text instanceof JsonElement) {
                return Enum.valueOf(clazz, (String)this.convertJsonPrimitive((JsonElement)text));
            }
            return Enum.valueOf(clazz, String.valueOf(text));
        }
        for (Class<?> current : allClasses = clazz.getClasses()) {
            if (!current.isEnum()) continue;
            if (text instanceof JsonElement) {
                return Enum.valueOf(current, (String)this.convertJsonPrimitive((JsonElement)text));
            }
            return Enum.valueOf(current, String.valueOf(text));
        }
        return null;
    }

    private boolean isEnum(Class<?> clazz, Object text) {
        return clazz.isEnum() || text instanceof Enum;
    }

    private <T> T convertBean(Class<T> clazz, JsonObject toConvert, int depth) {
        SimplePropertyDescriptor[] allProperties;
        T t = this.newInstance(clazz);
        for (SimplePropertyDescriptor property : allProperties = SimplePropertyDescriptor.getPropertyDescriptors(clazz)) {
            if (!toConvert.has(property.getName())) continue;
            JsonElement value = toConvert.get(property.getName());
            Method write = property.getWriteMethod();
            if (write == null) continue;
            Class<?> type = write.getParameterTypes()[0];
            try {
                if (value.isJsonNull()) {
                    value = null;
                }
                write.invoke(t, this.convert(type, value, depth + 1));
            }
            catch (IllegalArgumentException e) {
                throw this.propertyWriteException(property, value, type, e);
            }
            catch (IllegalAccessException e) {
                throw this.propertyWriteException(property, value, type, e);
            }
            catch (InvocationTargetException e) {
                throw this.propertyWriteException(property, value, type, e);
            }
        }
        return t;
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private WebDriverException propertyWriteException(SimplePropertyDescriptor property, Object value, Class<?> type, Throwable cause) {
        throw new WebDriverException(String.format("Property name: %s -> %s on class %s", property.getName(), value, type), cause);
    }

    private Map convertMap(JsonObject toConvert, int depth) {
        HashMap map = new HashMap();
        for (Map.Entry entry : toConvert.entrySet()) {
            map.put(entry.getKey(), this.convert(Object.class, entry.getValue(), depth + 1));
        }
        return map;
    }

    private List convertList(JsonArray toConvert, int depth) {
        ArrayList<Object> list = new ArrayList<Object>(toConvert.size());
        for (int i = 0; i < toConvert.size(); ++i) {
            list.add(this.convert(Object.class, toConvert.get(i), depth + 1));
        }
        return list;
    }

    private boolean isPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Void.class.isAssignableFrom(clazz);
    }
}

