/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class OkMessages {
    private OkMessages() {
    }

    protected static Request toOkHttpRequest(URI baseUrl, HttpRequest request) {
        Request.Builder builder = new Request.Builder();
        String rawUrl = request.getUri().startsWith("ws://") ? "http://" + request.getUri().substring("ws://".length()) : (request.getUri().startsWith("wss://") ? "https://" + request.getUri().substring("wss://".length()) : (request.getUri().startsWith("http://") || request.getUri().startsWith("https://") ? request.getUri() : baseUrl.toString().replaceAll("/$", "") + request.getUri()));
        HttpUrl parsed = HttpUrl.parse((String)rawUrl);
        if (parsed == null) {
            throw new UncheckedIOException(new IOException("Unable to parse URL: " + baseUrl.toString() + request.getUri()));
        }
        HttpUrl.Builder url = parsed.newBuilder();
        for (String name : request.getQueryParameterNames()) {
            for (String value : request.getQueryParameters(name)) {
                url.addQueryParameter(name, value);
            }
        }
        builder.url(url.build());
        for (String name : request.getHeaderNames()) {
            for (String value : request.getHeaders(name)) {
                builder.addHeader(name, value);
            }
        }
        switch (request.getMethod()) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                String rawType = Optional.ofNullable(request.getHeader("Content-Type")).orElse("application/json; charset=utf-8");
                MediaType type = MediaType.parse((String)rawType);
                RequestBody body = RequestBody.create((MediaType)type, (byte[])Contents.bytes((Supplier)request.getContent()));
                builder.post(body);
                break;
            }
            case DELETE: {
                builder.delete();
            }
        }
        return builder.build();
    }

    public static HttpResponse toSeleniumResponse(final Response response) {
        HttpResponse toReturn = new HttpResponse();
        toReturn.setStatus(response.code());
        toReturn.setContent(response.body() == null ? Contents.empty() : Contents.memoize(() -> {
            final InputStream stream = response.body().byteStream();
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return stream.read();
                }

                @Override
                public void close() throws IOException {
                    response.close();
                    super.close();
                }
            };
        }));
        response.headers().names().forEach(name -> response.headers(name).forEach(value -> toReturn.addHeader(name, value)));
        return toReturn;
    }
}

