/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.RemoteCall;
import org.openqa.selenium.remote.http.netty.CreateNettyClient;
import org.openqa.selenium.remote.http.netty.NettyMessages;

public class NettyHttpHandler
extends RemoteCall {
    private final AsyncHttpClient client;
    private final HttpHandler handler;

    public NettyHttpHandler(ClientConfig config) {
        super(config);
        this.client = new CreateNettyClient().apply(config);
        this.handler = config.filter().andFinally(this::makeCall);
    }

    public HttpResponse execute(HttpRequest request) {
        return this.handler.execute(request);
    }

    private HttpResponse makeCall(HttpRequest request) {
        Objects.requireNonNull(request, "Request must be set.");
        ListenableFuture whenResponse = this.client.executeRequest(NettyMessages.toNettyRequest(this.getConfig().baseUri(), request));
        try {
            Response response = (Response)whenResponse.get();
            return NettyMessages.toSeleniumResponse(response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("NettyHttpHandler request interrupted", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("NettyHttpHandler request execution error", e);
        }
    }
}

