/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import java.io.InputStream;
import java.net.URI;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class NettyMessages {
    private NettyMessages() {
    }

    protected static Request toNettyRequest(URI baseUrl, HttpRequest request) {
        String rawUrl = request.getUri().startsWith("ws://") ? "http://" + request.getUri().substring("ws://".length()) : (request.getUri().startsWith("wss://") ? "https://" + request.getUri().substring("wss://".length()) : (request.getUri().startsWith("http://") || request.getUri().startsWith("https://") ? request.getUri() : baseUrl.toString().replaceAll("/$", "") + request.getUri()));
        RequestBuilder builder = Dsl.request((String)request.getMethod().toString(), (String)rawUrl);
        for (String name : request.getQueryParameterNames()) {
            for (String value : request.getQueryParameters(name)) {
                builder.addQueryParam(name, value);
            }
        }
        for (String name : request.getHeaderNames()) {
            for (String value : request.getHeaders(name)) {
                builder.addHeader((CharSequence)name, value);
            }
        }
        if (request.getMethod().equals((Object)HttpMethod.POST)) {
            builder.setBody((InputStream)request.getContent().get());
        }
        return builder.build();
    }

    public static HttpResponse toSeleniumResponse(Response response) {
        HttpResponse toReturn = new HttpResponse();
        toReturn.setStatus(response.getStatusCode());
        toReturn.setContent(!response.hasResponseBody() ? Contents.empty() : Contents.memoize(() -> ((Response)response).getResponseBodyAsStream()));
        response.getHeaders().names().forEach(name -> response.getHeaders((CharSequence)name).forEach(value -> toReturn.addHeader(name, value)));
        return toReturn;
    }
}

