/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Request;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.netty.CreateNettyClient;
import org.openqa.selenium.remote.http.netty.NettyMessages;

class NettyWebSocket
implements WebSocket {
    private static final Logger log = Logger.getLogger(NettyWebSocket.class.getName());
    private org.asynchttpclient.ws.WebSocket socket;

    private NettyWebSocket(AsyncHttpClient client, Request request, final WebSocket.Listener listener) {
        Objects.requireNonNull(client, "HTTP client to use must be set.");
        Objects.requireNonNull(listener, "WebSocket listener must be set.");
        try {
            URL origUrl = new URL(request.getUrl());
            URI wsUri = new URI("ws", null, origUrl.getHost(), origUrl.getPort(), origUrl.getPath(), null, null);
            this.socket = (org.asynchttpclient.ws.WebSocket)client.prepareGet(wsUri.toString()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(org.asynchttpclient.ws.WebSocket websocket) {
                }

                public void onClose(org.asynchttpclient.ws.WebSocket websocket, int code, String reason) {
                    listener.onClose(code, reason);
                }

                public void onError(Throwable t) {
                    listener.onError(t);
                }

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    if (payload != null) {
                        listener.onText((CharSequence)payload);
                    }
                }
            }).build()).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.log(Level.WARNING, "NettyWebSocket initial request interrupted", e);
        }
        catch (MalformedURLException | URISyntaxException | ExecutionException e) {
            throw new RuntimeException("NettyWebSocket initial request execution error", e);
        }
    }

    static BiFunction<HttpRequest, WebSocket.Listener, WebSocket> create(ClientConfig config) {
        Filter filter = config.filter();
        Function<HttpRequest, HttpRequest> filterRequest = req -> {
            AtomicReference ref = new AtomicReference();
            filter.andFinally(in -> {
                ref.set(in);
                return new HttpResponse();
            }).execute(req);
            return (HttpRequest)ref.get();
        };
        AsyncHttpClient client = new CreateNettyClient().apply(config);
        return (req, listener) -> {
            HttpRequest filtered = (HttpRequest)filterRequest.apply((HttpRequest)req);
            Request nettyReq = NettyMessages.toNettyRequest(config.baseUri(), filtered);
            return new NettyWebSocket(client, nettyReq, (WebSocket.Listener)listener);
        };
    }

    public WebSocket sendText(CharSequence data) {
        this.socket.sendTextFrame(data.toString());
        return this;
    }

    public void close() {
        this.socket.sendCloseFrame(1000, "WebDriver closing socket");
    }

    public void abort() {
    }
}

