/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.HttpRequest;

public class HttpTracing {
    private static final Logger LOG = Logger.getLogger(HttpTracing.class.getName());

    private HttpTracing() {
    }

    public static SpanContext extract(Tracer tracer, HttpRequest request) {
        Objects.requireNonNull(tracer, "Tracer to use must be set.");
        Objects.requireNonNull(request, "Request must be set.");
        return tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpRequestAdapter(request));
    }

    public static void inject(Tracer tracer, Span span, HttpRequest request) {
        if (span == null) {
            return;
        }
        Objects.requireNonNull(tracer, "Tracer to use must be set.");
        Objects.requireNonNull(request, "Request must be set.");
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        LOG.info(String.format("Injecting %s into %s at %s:%d", request, span, caller.getClassName(), caller.getLineNumber()));
        span.setTag(Tags.HTTP_METHOD.getKey(), request.getMethod().toString());
        span.setTag(Tags.HTTP_URL.getKey(), request.getUri());
        tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpRequestAdapter(request));
    }

    private static class HttpRequestAdapter
    implements TextMap {
        private final HttpRequest request;

        public HttpRequestAdapter(HttpRequest request) {
            this.request = Objects.requireNonNull(request, "Request to use must be set.");
        }

        public void put(String key, String value) {
            Objects.requireNonNull(key, "Key to use must be set.");
            Objects.requireNonNull(value, "Value to use must be set.");
            this.request.setHeader(key, value);
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return HttpRequestAdapter.asMap(this.request).entrySet().iterator();
        }

        private static Map<String, String> asMap(HttpRequest request) {
            LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
            request.getHeaderNames().forEach(name -> request.getHeaders(name).forEach(value -> {
                if (value != null) {
                    entries.put((String)name, (String)value);
                }
            }));
            return entries;
        }
    }
}

