/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;

public class SpanWrappedHttpHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(SpanWrappedHttpHandler.class.getName());
    private final Tracer tracer;
    private final Function<HttpRequest, String> namer;
    private final HttpHandler delegate;

    public SpanWrappedHttpHandler(Tracer tracer, Function<HttpRequest, String> namer, HttpHandler delegate) {
        this.tracer = Objects.requireNonNull(tracer, "Tracer to use must be set.");
        this.namer = Objects.requireNonNull(namer, "Naming function must be set.");
        this.delegate = Objects.requireNonNull(delegate, "Actual handler must be set.");
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        String name = Objects.requireNonNull(this.namer.apply(req), "Operation name must be set for " + req);
        Span previousSpan = this.tracer.scopeManager().activeSpan();
        SpanContext context = HttpTracing.extract(this.tracer, req);
        Span span = this.tracer.buildSpan(name).asChildOf(context).ignoreActiveSpan().start();
        this.tracer.scopeManager().activate(span);
        try {
            span.setTag((Tag)Tags.SPAN_KIND, (Object)"server").setTag((Tag)Tags.HTTP_METHOD, (Object)req.getMethod().toString()).setTag((Tag)Tags.HTTP_URL, (Object)req.getUri());
            HttpTracing.inject(this.tracer, span, req);
            HttpResponse res = this.delegate.execute(req);
            span.setTag((Tag)Tags.HTTP_STATUS, (Object)res.getStatus());
            HttpResponse httpResponse = res;
            return httpResponse;
        }
        catch (Throwable t) {
            span.setTag((Tag)Tags.ERROR, (Object)true);
            throw t;
        }
        finally {
            span.finish();
            this.tracer.scopeManager().activate(previousSpan);
        }
    }
}

