/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.okhttp;

import java.io.IOException;
import java.io.UncheckedIOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.RemoteCall;
import org.openqa.selenium.remote.http.okhttp.CreateOkClient;
import org.openqa.selenium.remote.http.okhttp.OkMessages;

public class OkHandler
extends RemoteCall {
    private final OkHttpClient client;
    private final HttpHandler handler;

    public OkHandler(ClientConfig config) {
        super(config);
        this.client = new CreateOkClient().apply(config);
        this.handler = config.filter().andFinally(this::makeCall);
    }

    public HttpResponse execute(HttpRequest request) {
        return this.handler.execute(request);
    }

    private HttpResponse makeCall(HttpRequest request) {
        Require.nonNull((String)"Request", (Object)request);
        try {
            Request okReq = OkMessages.toOkHttpRequest(this.getConfig().baseUri(), request);
            Response response = this.client.newCall(okReq).execute();
            return OkMessages.toSeleniumResponse(response);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

