/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.net.URI;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class NettyMessages {
    private NettyMessages() {
    }

    protected static Request toNettyRequest(URI baseUrl, HttpRequest request) {
        String info;
        String uri = request.getUri();
        String rawUrl = uri.startsWith("ws://") ? "http://" + uri.substring("ws://".length()) : (uri.startsWith("wss://") ? "https://" + uri.substring("wss://".length()) : (uri.startsWith("http://") || uri.startsWith("https://") ? uri : baseUrl.toString().replaceAll("/$", "") + uri));
        RequestBuilder builder = Dsl.request((String)request.getMethod().toString(), (String)rawUrl);
        for (String name : request.getQueryParameterNames()) {
            for (String value : request.getQueryParameters(name)) {
                builder.addQueryParam(name, value);
            }
        }
        for (String name : request.getHeaderNames()) {
            for (String value : request.getHeaders(name)) {
                builder.addHeader((CharSequence)name, value);
            }
        }
        if (request.getHeader("User-Agent") == null) {
            builder.addHeader((CharSequence)"User-Agent", AddSeleniumUserAgent.USER_AGENT);
        }
        if (!Strings.isNullOrEmpty((String)(info = baseUrl.getUserInfo()))) {
            String[] parts = info.split(":", 2);
            String user = parts[0];
            String pass = parts.length > 1 ? parts[1] : null;
            builder.setRealm(Dsl.basicAuthRealm((String)user, (String)pass).setUsePreemptiveAuth(true).build());
        }
        if (request.getMethod().equals((Object)HttpMethod.POST)) {
            builder.setBody((InputStream)request.getContent().get());
        }
        return builder.build();
    }

    public static HttpResponse toSeleniumResponse(Response response) {
        HttpResponse toReturn = new HttpResponse();
        toReturn.setStatus(response.getStatusCode());
        toReturn.setContent(!response.hasResponseBody() ? Contents.empty() : Contents.memoize(() -> ((Response)response).getResponseBodyAsStream()));
        response.getHeaders().names().forEach(name -> response.getHeaders((CharSequence)name).forEach(value -> toReturn.addHeader(name, value)));
        return toReturn;
    }
}

