/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.FileBackedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.session.CapabilitiesFilter;
import org.openqa.selenium.remote.session.CapabilityTransform;
import org.openqa.selenium.remote.session.ChromeFilter;
import org.openqa.selenium.remote.session.EdgeFilter;
import org.openqa.selenium.remote.session.FirefoxFilter;
import org.openqa.selenium.remote.session.InternetExplorerFilter;
import org.openqa.selenium.remote.session.OperaFilter;
import org.openqa.selenium.remote.session.ProxyTransform;
import org.openqa.selenium.remote.session.SafariFilter;
import org.openqa.selenium.remote.session.StripAnyPlatform;
import org.openqa.selenium.remote.session.W3CPlatformNameNormaliser;

public class NewSessionPayload
implements Closeable {
    private final Set<CapabilitiesFilter> adapters;
    private final Set<CapabilityTransform> transforms;
    private static final Dialect DEFAULT_DIALECT = Dialect.OSS;
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();
    private final Json json = new Json();
    private final FileBackedOutputStream backingStore;
    private final ImmutableSet<Dialect> dialects;

    public static NewSessionPayload create(Capabilities caps) {
        return NewSessionPayload.create(ImmutableMap.of((Object)"desiredCapabilities", (Object)caps.asMap()));
    }

    public static NewSessionPayload create(Map<String, ?> source) {
        String json = new Json().toJson(Require.nonNull((String)"Payload", source));
        return new NewSessionPayload(new StringReader(json));
    }

    public static NewSessionPayload create(Reader source) {
        return new NewSessionPayload(source);
    }

    private NewSessionPayload(Reader source) {
        int threshold = (int)Math.min(Integer.MAX_VALUE, Math.min(Runtime.getRuntime().freeMemory() / 5L, Runtime.getRuntime().maxMemory() / 10L));
        this.backingStore = new FileBackedOutputStream(threshold);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.backingStore, StandardCharsets.UTF_8);){
            CharStreams.copy((Readable)source, (Appendable)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ImmutableSet.Builder adapters = ImmutableSet.builder();
        ServiceLoader.load(CapabilitiesFilter.class).forEach(arg_0 -> ((ImmutableSet.Builder)adapters).add(arg_0));
        adapters.add((Object)new ChromeFilter()).add((Object)new EdgeFilter()).add((Object)new FirefoxFilter()).add((Object)new InternetExplorerFilter()).add((Object)new OperaFilter()).add((Object)new SafariFilter());
        this.adapters = adapters.build();
        ImmutableSet.Builder transforms = ImmutableSet.builder();
        ServiceLoader.load(CapabilityTransform.class).forEach(arg_0 -> ((ImmutableSet.Builder)transforms).add(arg_0));
        transforms.add((Object)new ProxyTransform()).add((Object)new StripAnyPlatform()).add((Object)new W3CPlatformNameNormaliser());
        this.transforms = transforms.build();
        ImmutableSet.Builder dialects = ImmutableSet.builder();
        try {
            if (this.getOss() != null) {
                dialects.add((Object)Dialect.OSS);
            }
            if (this.getAlwaysMatch() != null || this.getFirstMatches() != null) {
                dialects.add((Object)Dialect.W3C);
            }
            this.dialects = dialects.build();
            this.validate();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void validate() throws IOException {
        ImmutableMap alwaysMatch = this.getAlwaysMatch();
        if (alwaysMatch == null) {
            alwaysMatch = ImmutableMap.of();
        }
        ImmutableMap always = alwaysMatch;
        ImmutableList firsts = this.getFirstMatches();
        if (firsts == null) {
            firsts = ImmutableList.of((Object)ImmutableMap.of());
        }
        if (firsts.isEmpty()) {
            throw new IllegalArgumentException("First match w3c capabilities is zero length");
        }
        firsts.stream().peek(arg_0 -> NewSessionPayload.lambda$validate$0((Map)always, arg_0)).map(arg_0 -> NewSessionPayload.lambda$validate$1((Map)always, arg_0)).peek(map -> {
            ImmutableSortedSet nullKeys = (ImmutableSortedSet)map.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
            if (!nullKeys.isEmpty()) {
                throw new IllegalArgumentException("Null values found in w3c capabilities. Keys are: " + nullKeys);
            }
        }).peek(map -> {
            ImmutableSortedSet illegalKeys = (ImmutableSortedSet)map.entrySet().stream().filter(entry -> !ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).map(Map.Entry::getKey).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
            if (!illegalKeys.isEmpty()) {
                throw new IllegalArgumentException("Illegal key values seen in w3c capabilities: " + illegalKeys);
            }
        }).forEach(map -> {});
    }

    public void writeTo(Appendable appendable) throws IOException {
        try (JsonOutput json = new Json().newOutput(appendable);){
            Map<String, Object> proxyMap;
            json.beginObject();
            Map first = this.getOss();
            if (first == null) {
                first = this.stream().findFirst().orElse((Capabilities)new ImmutableCapabilities()).asMap();
            }
            HashMap<String, Object> ossFirst = new HashMap<String, Object>(first);
            if (first.containsKey("proxy") && (proxyMap = this.getProxyFromCapabilities(first)).containsKey("noProxy")) {
                HashMap<String, Object> ossProxyMap = new HashMap<String, Object>(proxyMap);
                Object rawData = proxyMap.get("noProxy");
                if (rawData instanceof List) {
                    ossProxyMap.put("noProxy", String.join((CharSequence)",", (List)rawData));
                }
                ossFirst.put("proxy", ossProxyMap);
            }
            json.name("desiredCapabilities");
            json.write(ossFirst);
            json.name("capabilities");
            json.beginObject();
            json.name("firstMatch");
            json.beginArray();
            this.getW3C().forEach(arg_0 -> ((JsonOutput)json).write(arg_0));
            json.endArray();
            json.endObject();
            this.writeMetaData(json);
            json.endObject();
        }
    }

    private Map<String, Object> getProxyFromCapabilities(Map<String, Object> capabilities) {
        Object rawProxy = capabilities.get("proxy");
        if (rawProxy instanceof Proxy) {
            return ((Proxy)rawProxy).toJson();
        }
        if (rawProxy instanceof Map) {
            return (Map)rawProxy;
        }
        return new HashMap<String, Object>();
    }

    private void writeMetaData(JsonOutput out) throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput((Reader)reader);){
            input.beginObject();
            block18: while (input.hasNext()) {
                String name;
                switch (name = input.nextName()) {
                    case "capabilities": 
                    case "desiredCapabilities": 
                    case "requiredCapabilities": {
                        input.skipValue();
                        continue block18;
                    }
                }
                out.name(name);
                out.write(input.read(Object.class));
            }
        }
    }

    public Stream<Capabilities> stream() {
        try {
            Stream<Map<String, Object>> oss = Stream.of(this.getOss());
            Stream<Map<String, Object>> w3c = this.getW3C();
            return Stream.concat(oss, w3c).filter(Objects::nonNull).map(this::applyTransforms).filter(Objects::nonNull).distinct().map(ImmutableCapabilities::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Set<Dialect> getDownstreamDialects() {
        return this.dialects.isEmpty() ? ImmutableSet.of((Object)((Object)DEFAULT_DIALECT)) : this.dialects;
    }

    @Override
    public void close() {
        try {
            this.backingStore.reset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<String, Object> getOss() throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput((Reader)reader);){
            input.beginObject();
            while (true) {
                if (input.hasNext()) {
                    String name = input.nextName();
                    if ("desiredCapabilities".equals(name)) {
                        Map map = (Map)input.read(Json.MAP_TYPE);
                        return map;
                    }
                    input.skipValue();
                    continue;
                }
                break;
            }
        }
        return null;
    }

    private Stream<Map<String, Object>> getW3C() throws IOException {
        Stream<Map> fromW3c;
        Stream<Map> fromOss;
        Map<String, Object> oss = this.convertOssToW3C(this.getOss());
        if (oss != null) {
            HashSet usedKeys = new HashSet();
            List firsts = (List)this.adapters.stream().map(adapter -> adapter.apply(oss)).filter(Objects::nonNull).filter(map -> !map.isEmpty()).map(map -> map.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).peek(map -> usedKeys.addAll(map.keySet())).collect(ImmutableList.toImmutableList());
            if (firsts.isEmpty()) {
                firsts = ImmutableList.of((Object)ImmutableMap.of());
            }
            Map always = (Map)oss.entrySet().stream().filter(entry -> !usedKeys.contains(entry.getKey())).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            fromOss = firsts.stream().map(first -> ImmutableMap.builder().putAll(always).putAll(first).build()).map(this::applyTransforms).map(map -> (Map)map.entrySet().stream().filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        } else {
            fromOss = Stream.of(new Map[0]);
        }
        ImmutableMap alwaysMatch = this.getAlwaysMatch();
        ImmutableList firsts = this.getFirstMatches();
        if (alwaysMatch == null && firsts == null) {
            fromW3c = Stream.of(new Map[0]);
        } else {
            if (alwaysMatch == null) {
                alwaysMatch = ImmutableMap.of();
            }
            ImmutableMap always = alwaysMatch;
            if (firsts == null) {
                firsts = ImmutableList.of((Object)ImmutableMap.of());
            }
            fromW3c = firsts.stream().map(arg_0 -> NewSessionPayload.lambda$getW3C$19((Map)always, arg_0));
        }
        return Stream.concat(fromOss, fromW3c).distinct();
    }

    private Map<String, Object> convertOssToW3C(Map<String, Object> capabilities) {
        Map<String, Object> proxyMap;
        if (capabilities == null) {
            return null;
        }
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>(capabilities);
        if (capabilities.containsKey("platform") && !capabilities.containsKey("platformName")) {
            toReturn.put("platformName", String.valueOf(capabilities.get("platform")));
        }
        if (capabilities.containsKey("proxy") && (proxyMap = this.getProxyFromCapabilities(capabilities)).containsKey("noProxy")) {
            HashMap<String, Object> w3cProxyMap = new HashMap<String, Object>(proxyMap);
            Object rawData = proxyMap.get("noProxy");
            if (rawData instanceof String) {
                w3cProxyMap.put("noProxy", Arrays.asList(((String)rawData).split(",\\s*")));
            }
            toReturn.put("proxy", w3cProxyMap);
        }
        return toReturn;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> getAlwaysMatch() throws IOException {
        block17: {
            charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
            reader = charSource.openBufferedStream();
            try {
                input = this.json.newInput((Reader)reader);
                try {
                    input.beginObject();
                    while (true) {
                        block19: {
                            block20: {
                                block18: {
                                    if (!input.hasNext()) break block17;
                                    name = input.nextName();
                                    if (!"capabilities".equals(name)) break block19;
                                    input.beginObject();
lbl12:
                                    // 2 sources

                                    while (input.hasNext()) {
                                        name = input.nextName();
                                        if ("alwaysMatch".equals(name)) {
                                            var5_8 = (Map)input.read(Json.MAP_TYPE);
                                            return var5_8;
                                        }
                                        break block18;
                                    }
                                    break block20;
                                }
                                input.skipValue();
                                ** GOTO lbl12
                            }
                            input.endObject();
                            continue;
                        }
                        input.skipValue();
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Collection<Map<String, Object>> getFirstMatches() throws IOException {
        block17: {
            charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
            reader = charSource.openBufferedStream();
            try {
                input = this.json.newInput((Reader)reader);
                try {
                    input.beginObject();
                    while (true) {
                        block19: {
                            block20: {
                                block18: {
                                    if (!input.hasNext()) break block17;
                                    name = input.nextName();
                                    if (!"capabilities".equals(name)) break block19;
                                    input.beginObject();
lbl12:
                                    // 2 sources

                                    while (input.hasNext()) {
                                        name = input.nextName();
                                        if ("firstMatch".equals(name)) {
                                            var5_8 = (Collection)input.read(Json.LIST_OF_MAPS_TYPE);
                                            return var5_8;
                                        }
                                        break block18;
                                    }
                                    break block20;
                                }
                                input.skipValue();
                                ** GOTO lbl12
                            }
                            input.endObject();
                            continue;
                        }
                        input.skipValue();
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return null;
    }

    private Map<String, Object> applyTransforms(Map<String, Object> caps) {
        LinkedList<Map.Entry<String, Object>> toExamine = new LinkedList<Map.Entry<String, Object>>(caps.entrySet());
        HashSet<String> seenKeys = new HashSet<String>();
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        block0: while (!toExamine.isEmpty()) {
            Map.Entry<String, Object> entry = (Map.Entry<String, Object>)toExamine.remove();
            seenKeys.add((String)entry.getKey());
            if (entry.getValue() == null) continue;
            for (CapabilityTransform transform : this.transforms) {
                Collection<Map.Entry<String, Object>> result = transform.apply(entry);
                if (result == null) {
                    toReturn.remove(entry.getKey());
                    continue block0;
                }
                for (Map.Entry<String, Object> newEntry : result) {
                    if (!seenKeys.contains(newEntry.getKey())) {
                        toExamine.add(newEntry);
                        continue;
                    }
                    if (newEntry.getKey().equals(entry.getKey())) {
                        entry = newEntry;
                    }
                    toReturn.put(newEntry.getKey(), newEntry.getValue());
                }
            }
        }
        return toReturn;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        try {
            this.writeTo(res);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.toString();
    }

    private static /* synthetic */ Map lambda$getW3C$19(Map always, Map first) {
        return ImmutableMap.builder().putAll(always).putAll(first).build();
    }

    private static /* synthetic */ Map lambda$validate$1(Map always, Map first) {
        HashMap toReturn = new HashMap();
        toReturn.putAll(always);
        toReturn.putAll(first);
        return toReturn;
    }

    private static /* synthetic */ void lambda$validate$0(Map always, Map map) {
        Sets.SetView overlap = Sets.intersection(always.keySet(), map.keySet());
        if (!overlap.isEmpty()) {
            throw new IllegalArgumentException("Overlapping keys between w3c always and first match capabilities: " + overlap);
        }
    }
}

