/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.ConnectionFailedException;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.netty.NettyClient;
import org.openqa.selenium.remote.http.netty.NettyMessages;

class NettyWebSocket
implements WebSocket {
    private static final Logger log = Logger.getLogger(NettyWebSocket.class.getName());
    private final org.asynchttpclient.ws.WebSocket socket;

    private NettyWebSocket(AsyncHttpClient client, Request request, final WebSocket.Listener listener) {
        Require.nonNull((String)"HTTP client", (Object)client);
        Require.nonNull((String)"WebSocket listener", (Object)listener);
        try {
            URL origUrl = new URL(request.getUrl());
            String wsScheme = "https".equalsIgnoreCase(origUrl.getProtocol()) ? "wss" : "ws";
            URI wsUri = new URI(wsScheme, null, origUrl.getHost(), origUrl.getPort(), origUrl.getPath(), null, null);
            ListenableFuture future = client.prepareGet(wsUri.toString()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(org.asynchttpclient.ws.WebSocket websocket) {
                }

                public void onClose(org.asynchttpclient.ws.WebSocket websocket, int code, String reason) {
                    listener.onClose(code, reason);
                }

                public void onError(Throwable t) {
                    listener.onError(t);
                }

                public void onBinaryFrame(byte[] payload, boolean finalFragment, int rsv) {
                    if (payload != null) {
                        listener.onBinary(payload);
                    }
                }

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    if (payload != null) {
                        listener.onText((CharSequence)payload);
                    }
                }
            }).build());
            this.socket = (org.asynchttpclient.ws.WebSocket)((CompletableFuture)future.toCompletableFuture().exceptionally(t -> {
                log.log(Level.WARNING, t.getMessage(), (Throwable)t);
                return null;
            })).get();
            if (this.socket == null) {
                throw new ConnectionFailedException("Unable to establish websocket connection to " + request.getUrl());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.log(Level.WARNING, "NettyWebSocket initial request interrupted", e);
            throw new ConnectionFailedException("NettyWebSocket initial request interrupted", (Throwable)e);
        }
        catch (MalformedURLException | URISyntaxException | ExecutionException e) {
            throw new ConnectionFailedException("NettyWebSocket initial request execution error", (Throwable)e);
        }
    }

    static BiFunction<HttpRequest, WebSocket.Listener, WebSocket> create(ClientConfig config, AsyncHttpClient client) {
        Filter filter = config.filter();
        Function<HttpRequest, HttpRequest> filterRequest = req -> {
            AtomicReference ref = new AtomicReference();
            filter.andFinally(in -> {
                ref.set(in);
                return new HttpResponse();
            }).execute(req);
            return (HttpRequest)ref.get();
        };
        return (req, listener) -> {
            HttpRequest filtered = (HttpRequest)filterRequest.apply((HttpRequest)req);
            Request nettyReq = NettyMessages.toNettyRequest(config.baseUri(), NettyClient.toClampedInt(config.readTimeout().toMillis()), NettyClient.toClampedInt(config.readTimeout().toMillis()), filtered);
            return new NettyWebSocket(client, nettyReq, (WebSocket.Listener)listener);
        };
    }

    public WebSocket send(Message message) {
        if (message instanceof BinaryMessage) {
            this.socket.sendBinaryFrame(((BinaryMessage)message).data());
        } else if (message instanceof CloseMessage) {
            this.socket.sendCloseFrame(((CloseMessage)message).code(), ((CloseMessage)message).reason());
        } else if (message instanceof TextMessage) {
            this.socket.sendTextFrame(((TextMessage)message).text());
        }
        return this;
    }

    public WebSocket sendText(CharSequence data) {
        this.socket.sendTextFrame(data.toString());
        return this;
    }

    public void close() {
        this.socket.sendCloseFrame(1000, "WebDriver closing socket");
    }
}

