/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.service.DriverService;

public class DriverCommandExecutor
extends HttpCommandExecutor
implements Closeable {
    private final DriverService service;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2, r -> {
        Thread thread = new Thread(r);
        thread.setName("Driver Command Executor");
        thread.setDaemon(true);
        return thread;
    });

    public DriverCommandExecutor(DriverService service) {
        super((URL)Require.nonNull((String)"DriverService", (Object)service.getUrl()));
        this.service = service;
    }

    protected DriverCommandExecutor(DriverService service, Map<String, CommandInfo> additionalCommands) {
        super(additionalCommands, service.getUrl());
        this.service = service;
    }

    @Override
    public Response execute(Command command) throws IOException {
        boolean newlyStarted = false;
        if ("newSession".equals(command.getName())) {
            boolean wasRunningBefore = this.service.isRunning();
            this.service.start();
            boolean bl = newlyStarted = !wasRunningBefore && this.service.isRunning();
        }
        if ("quit".equals(command.getName())) {
            CompletableFuture<Response> commandComplete = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.invokeExecute(command);
                }
                catch (Throwable t) {
                    Throwable rootCause = Throwables.getRootCause((Throwable)t);
                    if (rootCause instanceof IllegalStateException && "Closed".equals(rootCause.getMessage())) {
                        return null;
                    }
                    if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage())) {
                        throw new WebDriverException("The driver server has unexpectedly died!", t);
                    }
                    Throwables.throwIfUnchecked((Throwable)t);
                    throw new WebDriverException(t);
                }
            }, this.executorService);
            CompletableFuture<Response> processFinished = CompletableFuture.supplyAsync(() -> {
                this.service.process.waitFor(this.service.getTimeout().toMillis());
                return null;
            }, this.executorService);
            try {
                Response response = (Response)CompletableFuture.anyOf(commandComplete, processFinished).get(this.service.getTimeout().toMillis() * 2L, TimeUnit.MILLISECONDS);
                this.service.stop();
                Response response2 = response;
                return response2;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new WebDriverException("Timed out waiting for driver server to stop.", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException("Timed out waiting for driver server to stop.", (Throwable)e);
            }
            finally {
                this.executorService.shutdownNow();
            }
        }
        try {
            return this.invokeExecute(command);
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage()) && !this.service.isRunning()) {
                throw new WebDriverException("The driver server has unexpectedly died!", t);
            }
            if (newlyStarted && this.service.isRunning()) {
                try {
                    this.service.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new WebDriverException(t);
        }
    }

    @VisibleForTesting
    Response invokeExecute(Command command) throws IOException {
        return super.execute(command);
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
    }
}

