/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Propagator;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryPropagator;
import org.openqa.selenium.remote.tracing.opentelemetry.SeleniumSpanExporter;

public class OpenTelemetryTracer
implements Tracer {
    private static final Logger LOG = Logger.getLogger(OpenTelemetryTracer.class.getName());
    private static boolean HTTP_LOGS;
    private static volatile OpenTelemetryTracer singleton;
    private final io.opentelemetry.api.trace.Tracer tracer;
    private final OpenTelemetryPropagator telemetryPropagator;
    private Context context;

    public static void setHttpLogs(boolean value) {
        HTTP_LOGS = value;
    }

    public static boolean getHttpLogs() {
        return HTTP_LOGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenTelemetryTracer getInstance() {
        OpenTelemetryTracer localTracer = singleton;
        if (localTracer != null) return localTracer;
        Class<OpenTelemetryTracer> clazz = OpenTelemetryTracer.class;
        synchronized (OpenTelemetryTracer.class) {
            localTracer = singleton;
            if (localTracer != null) return localTracer;
            singleton = localTracer = OpenTelemetryTracer.createTracer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localTracer;
        }
    }

    private static OpenTelemetryTracer createTracer() {
        LOG.info("Using OpenTelemetry for tracing");
        System.setProperty("otel.metrics.exporter", "none");
        String exporter = System.getProperty("otel.traces.exporter");
        if (exporter == null) {
            System.setProperty("otel.traces.exporter", "none");
        }
        OpenTelemetrySdk autoConfiguredSdk = AutoConfiguredOpenTelemetrySdk.builder().addTracerProviderCustomizer((sdkTracerProviderBuilder, configProperties) -> sdkTracerProviderBuilder.addSpanProcessor(SeleniumSpanExporter.getSpanProcessor())).build().getOpenTelemetrySdk();
        return new OpenTelemetryTracer(autoConfiguredSdk.getTracer("default"), autoConfiguredSdk.getPropagators().getTextMapPropagator());
    }

    public OpenTelemetryTracer(io.opentelemetry.api.trace.Tracer tracer, TextMapPropagator propagator) {
        this.tracer = (io.opentelemetry.api.trace.Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.telemetryPropagator = new OpenTelemetryPropagator(tracer, (TextMapPropagator)Require.nonNull((String)"Formatter", (Object)propagator));
    }

    @Override
    public TraceContext getCurrentContext() {
        return new OpenTelemetryContext(this.tracer, this.context != null ? this.context : Context.current());
    }

    @Override
    public Propagator getPropagator() {
        return this.telemetryPropagator;
    }

    public void setOpenTelemetryContext(Context context) {
        this.context = context;
    }
}

