/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriverCommandExecutor;
import org.openqa.selenium.safari.SafariDriverExtension;

public class SafariDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public static final String CLEAN_SESSION_CAPABILITY = "safari.cleanSession";
    public static final String DATA_DIR_CAPABILITY = "safari.dataDir";

    public SafariDriver() {
        this((Capabilities)DesiredCapabilities.safari());
    }

    public SafariDriver(Capabilities desiredCapabilities) {
        super((CommandExecutor)new SafariDriverCommandExecutor(0, desiredCapabilities.is(CLEAN_SESSION_CAPABILITY), new SafariDriverExtension(SafariDriver.dataDirOrNull(desiredCapabilities))), desiredCapabilities);
    }

    private static File dataDirOrNull(Capabilities capabilities) {
        Object cap = capabilities.getCapability(DATA_DIR_CAPABILITY);
        if (cap instanceof String) {
            return new File((String)cap);
        }
        if (cap instanceof File) {
            return (File)cap;
        }
        return null;
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    protected void startClient() {
        SafariDriverCommandExecutor executor = (SafariDriverCommandExecutor)this.getCommandExecutor();
        try {
            executor.start();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    protected void stopClient() {
        SafariDriverCommandExecutor executor = (SafariDriverCommandExecutor)this.getCommandExecutor();
        executor.stop();
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64 = (String)this.execute("screenshot").getValue();
        return (X)target.convertFromBase64Png(base64);
    }
}

