/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriverService
extends DriverService {
    public static final String SAFARI_DRIVER_EXE_PROPERTY = "webdriver.safari.driver";
    private static final File SAFARI_DRIVER_EXECUTABLE = new File("/usr/bin/safaridriver");
    private static final File TP_SAFARI_DRIVER_EXECUTABLE = new File("/Applications/Safari Technology Preview.app/Contents/MacOS/safaridriver");

    public SafariDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static SafariDriverService createDefaultService() {
        return SafariDriverService.createDefaultService(new SafariOptions());
    }

    static SafariDriverService createDefaultService(SafariOptions options) {
        return (SafariDriverService)new Builder().usingTechnologyPreview(options.getUseTechnologyPreview()).build();
    }

    static SafariDriverService createDefaultService(Capabilities caps) {
        return SafariDriverService.createDefaultService(new SafariOptions(caps));
    }

    protected void waitUntilAvailable() {
        try {
            PortProber.waitForPortUp((int)this.getUrl().getPort(), (int)20, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public static class Builder
    extends DriverService.Builder<SafariDriverService, Builder> {
        private boolean useTechnologyPreview = false;

        public int score(Capabilities capabilities) {
            int score = 0;
            if ("safari".equals(capabilities.getBrowserName())) {
                ++score;
            } else if ("Safari Technology Preview".equals(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability("safari.options") != null) {
                ++score;
            }
            if (capabilities.getCapability("se:safari:techPreview") != null) {
                ++score;
            }
            return score;
        }

        public Builder usingTechnologyPreview(boolean useTechnologyPreview) {
            this.useTechnologyPreview = useTechnologyPreview;
            return this;
        }

        protected File findDefaultExecutable() {
            File exe = System.getProperty(SafariDriverService.SAFARI_DRIVER_EXE_PROPERTY) != null ? new File(System.getProperty(SafariDriverService.SAFARI_DRIVER_EXE_PROPERTY)) : (this.useTechnologyPreview ? TP_SAFARI_DRIVER_EXECUTABLE : SAFARI_DRIVER_EXECUTABLE);
            if (!exe.isFile()) {
                StringBuilder message = new StringBuilder();
                message.append("Unable to find driver executable: ").append(exe);
                if (!this.isElCapitanOrLater()) {
                    message.append("(SafariDriver requires Safari 10 running on OSX El Capitan or greater.)");
                }
                throw new WebDriverException(message.toString());
            }
            return exe;
        }

        private boolean isElCapitanOrLater() {
            if (!Platform.getCurrent().is(Platform.MAC)) {
                return false;
            }
            if (Platform.getCurrent().getMajorVersion() > 10) {
                return true;
            }
            return Platform.getCurrent().getMajorVersion() == 10 && Platform.getCurrent().getMinorVersion() >= 11;
        }

        protected ImmutableList<String> createArgs() {
            return ImmutableList.of((Object)"--port", (Object)String.valueOf(this.getPort()));
        }

        protected SafariDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new SafariDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

