/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.Proxies;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.Sleeper;

public class OperaCustomProfileLauncher
extends AbstractBrowserLauncher {
    static Logger log = Logger.getLogger(OperaCustomProfileLauncher.class.getName());
    private static final String DEFAULT_NONWINDOWS_LOCATION = "/Applications/Opera.app/Contents/MacOS/opera";
    private static boolean simple = false;
    private File customProfileDir;
    private String[] cmdarray;
    private boolean closed = false;
    private String commandPath;
    private CommandLine process;
    private static String additionalSettings = "";
    static final Pattern JAVA_STYLE_UNC_URL = Pattern.compile("^file:////([^/]+/.*)$");
    static final Pattern JAVA_STYLE_LOCAL_URL = Pattern.compile("^file:/([A-Z]:/.*)$");

    protected File locateBinaryInPath(String commandPath) {
        return new File(CommandLine.find((String)commandPath));
    }

    public OperaCustomProfileLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        super(sessionId, configuration, browserOptions);
        this.commandPath = browserLaunchLocation == null ? this.findBrowserLaunchLocation() : browserLaunchLocation;
        this.sessionId = sessionId;
    }

    private void getOperaBinary(CommandLine command) {
        if (!WindowsUtils.thisIsWindows()) {
            File execDirect;
            File operaBin = this.locateBinaryInPath(this.commandPath);
            if (operaBin == null && (execDirect = new File(this.commandPath)).isAbsolute() && execDirect.exists()) {
                operaBin = execDirect;
            }
            String libPathKey = CommandLine.getLibraryPathPropertyName();
            String libPath = WindowsUtils.loadEnvironment().getProperty(libPathKey);
            command.setEnvironmentVariable(libPathKey, libPath + ":" + operaBin.getParent());
        }
    }

    public static void setAdditionalSettings(String additionalSettings) {
        OperaCustomProfileLauncher.additionalSettings = additionalSettings;
    }

    protected String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("operaDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.thisIsWindows() ? WindowsUtils.getProgramFilesPath() + "\\Opera\\opera.exe" : DEFAULT_NONWINDOWS_LOCATION;
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        String operaBin = CommandLine.find((String)"opera");
        if (operaBin != null) {
            return operaBin;
        }
        throw new RuntimeException("Opera could not be found in the path!\nPlease add the directory containing opera.exe to your PATH environment\nvariable, or explicitly specify a path to Opera like this:\n *opera " + (Platform.getCurrent().is(Platform.WINDOWS) ? "/blah/blah/opera" : "C:\\blah\\opera.exe"));
    }

    @Override
    protected void launch(String url) {
        try {
            File opera6ini = this.makeCustomProfile();
            log.info("Launching Opera...");
            this.cmdarray = WindowsUtils.thisIsWindows() ? new String[]{this.commandPath, "/settings", opera6ini.getAbsolutePath(), url} : new String[]{this.commandPath, "-nosession", "-personaldir", opera6ini.getParentFile().getAbsolutePath(), url};
            this.process = new CommandLine(this.cmdarray);
            this.process.setEnvironmentVariable("MOZ_NO_REMOTE", "1");
            this.getOperaBinary(this.process);
            this.process.executeAsync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File makeCustomProfile() throws IOException {
        this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        ResourceExtractor.extractResourcePath(this.getClass(), "/opera", this.customProfileDir);
        if (simple) {
            return this.customProfileDir;
        }
        File proxyPAC = Proxies.makeProxyPAC(this.customProfileDir, this.getPort(), this.browserConfigurationOptions);
        File opera6ini = new File(this.customProfileDir, "opera6.ini");
        PrintStream out = new PrintStream(new FileOutputStream(opera6ini));
        out.println("[Proxy]");
        out.println("HTTP server=localhost:" + this.getPort());
        out.println("Enable HTTP 1.1 for proxy=1");
        out.println("Use Proxy On Local Names Check=1");
        out.println("Use HTTP=1");
        out.println("Use HTTPS=1");
        out.println("Use FTP=0");
        out.println("Use GOPHER=0");
        out.println("Use WAIS=0");
        out.println("Use Automatic Proxy Configuration=0");
        out.println("HTTPS server=localhost:" + this.getPort());
        out.println("FTP server=localhost:" + this.getPort());
        out.println("Gopher server=localhost:" + this.getPort());
        out.println("WAIS server");
        out.println("Automatic Proxy Configuration URL=" + proxyPAC.getAbsolutePath());
        out.println("No Proxy Servers");
        out.println("No Proxy Servers Check=0");
        out.println("");
        out.println("[Cache]");
        out.println("Cache Docs=0");
        out.println("Document=0");
        out.println("Figure=0");
        out.println("Cache Figs=0");
        out.println("");
        out.println("[Disk Cache]");
        out.println("Cache Docs=0");
        out.println("Enabled=0");
        out.println("Size=0");
        out.println("Docs Modification=1");
        out.println("Figs Modification=1");
        out.println("Other Modification=1");
        out.println("");
        out.println("[State]");
        out.println("Run=0");
        out.println("Accept License=1");
        out.println("[User Prefs]");
        out.println("Automatic RAM Cache=0");
        out.println("Opera Directory=" + this.customProfileDir.getAbsolutePath());
        out.println("Shown First Time Setup=1");
        out.println("One Time Page=");
        out.println("Show Setupdialog On Start=0");
        out.println("Enable Wand=0");
        out.println("Ignore Unrequested Popups=0");
        out.println("Show Default Browser Dialog=0");
        out.println("Check For New Opera=0");
        out.println("Show Startup Dialog=0");
        out.println("Startup Type=4");
        out.println("Has Shown KDE Shortcut Message=1");
        out.println("SDI=1");
        out.println("Maximize New Windows=3");
        out.println(additionalSettings);
        out.println("[Install]");
        out.println("HELLO=NO");
        out.println("Newest Used Version=2000");
        out.close();
        return opera6ini;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.process == null) {
            return;
        }
        log.info("Killing Opera...");
        Throwable taskKillException = null;
        FileLockRemainedException fileLockException = null;
        int exitValue = this.process.destroy();
        if (exitValue == 0) {
            log.warning("Opera seems to have ended on its own (did we kill the real browser???)");
        }
        try {
            this.waitForFileLockToGoAway(0L, 500L);
        }
        catch (FileLockRemainedException e1) {
            fileLockException = e1;
        }
        try {
            LauncherUtils.deleteTryTryAgain(this.customProfileDir, 6);
        }
        catch (RuntimeException e) {
            if (taskKillException != null || fileLockException != null) {
                log.log(Level.SEVERE, "Couldn't delete custom Opera profile directory", e);
                log.severe("Perhaps caused by this exception:");
                if (taskKillException != null) {
                    log.log(Level.SEVERE, "Perhaps caused by this exception:", taskKillException);
                }
                if (fileLockException != null) {
                    log.log(Level.SEVERE, "Perhaps caused by this exception:", fileLockException);
                }
                throw new RuntimeException("Couldn't delete custom Opera profile directory, presumably because task kill failed; see error log!", e);
            }
            throw e;
        }
        this.closed = true;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir, "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            Sleeper.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            Sleeper.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    public static void main(String[] args) throws Exception {
        OperaCustomProfileLauncher l = new OperaCustomProfileLauncher(BrowserOptions.newBrowserOptions(), new RemoteControlConfiguration(), "CUSTFF", null);
        l.launch("http://www.google.com");
        int seconds = 15;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        Sleeper.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public void setCommandPath(String commandPath) {
        this.commandPath = commandPath;
    }

    private class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

