/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.Proxies;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;

public class KonquerorLauncher
extends AbstractBrowserLauncher {
    private static final String KONQUEROR_PROFILE_SRC_LOCATION = "/konqueror";
    private static final String KONQUEROR_PROFILE_DEST_LOCATION = System.getProperty("user.home") + "/.kde/share/config";
    private static final String DEFAULT_KONQUEROR_LOCATION = "/usr/bin/konqueror";
    private CommandLine process;
    private String browserLaunchLocation;

    public KonquerorLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        super(sessionId, configuration, browserOptions);
        this.browserLaunchLocation = browserLaunchLocation;
    }

    @Override
    protected void launch(String url) {
        try {
            this.makeCustomProfile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.exec(this.browserLaunchLocation + " " + url);
    }

    private void makeCustomProfile() throws IOException {
        File profileDest = new File(KONQUEROR_PROFILE_DEST_LOCATION);
        ResourceExtractor.extractResourcePath(this.getClass(), KONQUEROR_PROFILE_SRC_LOCATION, profileDest);
        File pacFile = Proxies.makeProxyPAC(new File(KONQUEROR_PROFILE_DEST_LOCATION), this.getPort(), this.browserConfigurationOptions);
        File kioslaverc = new File(KONQUEROR_PROFILE_DEST_LOCATION, "kioslaverc");
        PrintStream out = new PrintStream(new FileOutputStream(kioslaverc));
        out.println("PersistentProxyConnection=false");
        out.println("[Proxy Settings]");
        out.println("AuthMode=0");
        out.println("Proxy Config Script=file://" + pacFile.getAbsolutePath());
        out.println("ProxyType=2");
        out.println("ReversedException=false");
        out.close();
    }

    @Override
    public void close() {
        if (this.process == null) {
            return;
        }
        this.process.destroy();
    }

    protected void exec(String command) {
        try {
            this.process = new CommandLine(command, new String[0]);
            this.process.executeAsync();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error starting browser by executing command " + command + ": " + e + "\n See http://openqa.org/selenium-rc/help/launching-konqueror.html");
        }
    }
}

