/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.security;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.openqa.selenium.io.IOUtils;
import org.openqa.selenium.server.security.KeyAndCert;

public class CertificateGenerator {
    private static final String KEY_PURPOSE_BASE = "1.3.6.1.5.5.7.3";
    private static final String SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    private static final String CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    private static final String BOUNCY_CASTLE = "BC";
    private static char[] SIGNING_PASSWORD = "password".toCharArray();
    private static final AtomicLong serialSeed = new AtomicLong(new Date().getTime() / 1000L);
    private final KeyAndCert caCert;
    private final File serializedStore;
    private final KeyPairGenerator pairGenerator;

    public CertificateGenerator(File root) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.serializedStore = new File(root, "cybervillainsCA.jks");
        try {
            this.pairGenerator = KeyPairGenerator.getInstance("RSA");
            this.pairGenerator.initialize(1024);
            this.caCert = this.readRootSigningCert();
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public KeyAndCert generateCertificate(String hostname, String certificateRevocationList) {
        X500Principal x500issuer = this.caCert.getCertificate().getIssuerX500Principal();
        String subject = String.format("CN=%s, OU=Test, O=CyberVillainsCA, L=Seattle, S=Washington, C=US", hostname);
        X500Principal x500subject = new X500Principal(subject);
        Date begin = new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L));
        Date end = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(365L));
        KeyPair keypair = this.pairGenerator.generateKeyPair();
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(keypair.getPublic().getEncoded())).readObject());
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(x500issuer, BigInteger.valueOf(serialSeed.getAndIncrement()), begin, end, x500subject, keypair.getPublic());
            builder.addExtension(X509Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            builder.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)info);
            AuthorityKeyIdentifier caIdentifier = new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(this.caCert.getCertificate());
            builder.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)caIdentifier);
            DERSequence typicalSSLServerExtendedKeyUsages = new DERSequence(new ASN1Encodable[]{new DERObjectIdentifier(SERVER_AUTH), new DERObjectIdentifier(CLIENT_AUTH)});
            builder.addExtension(X509Extension.extendedKeyUsage, false, (ASN1Encodable)typicalSSLServerExtendedKeyUsages);
            if (certificateRevocationList != null) {
                DistributionPoint crl = new DistributionPoint(new DistributionPointName(0, (ASN1Encodable)new GeneralName(6, certificateRevocationList)), null, null);
                builder.addExtension(X509Extension.cRLDistributionPoints, false, (ASN1Encodable)new CRLDistPoint(new DistributionPoint[]{crl}));
            }
            ContentSigner signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BOUNCY_CASTLE).build(this.caCert.getPrivateKey());
            X509CertificateHolder holder = builder.build(signer);
            X509Certificate cert = new JcaX509CertificateConverter().setProvider(BOUNCY_CASTLE).getCertificate(holder);
            return new KeyAndCert(keypair.getPrivate(), cert);
        }
        catch (GeneralSecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (OperatorCreationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyAndCert readRootSigningCert() {
        KeyAndCert keyAndCert;
        FileInputStream is = null;
        try {
            KeyStore keystore = KeyStore.getInstance("JKS");
            is = new FileInputStream(this.serializedStore);
            keystore.load(is, SIGNING_PASSWORD);
            X509Certificate caCert = (X509Certificate)keystore.getCertificate("signingCert");
            PrivateKey caPrivateKey = (PrivateKey)keystore.getKey("signingCertPrivKey", SIGNING_PASSWORD);
            keyAndCert = new KeyAndCert(caPrivateKey, caCert);
        }
        catch (KeyStoreException e) {
            try {
                throw Throwables.propagate((Throwable)e);
                catch (CertificateException e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
                catch (UnrecoverableKeyException e3) {
                    throw Throwables.propagate((Throwable)e3);
                }
                catch (NoSuchAlgorithmException e4) {
                    throw Throwables.propagate((Throwable)e4);
                }
                catch (FileNotFoundException e5) {
                    throw Throwables.propagate((Throwable)e5);
                }
                catch (IOException e6) {
                    throw Throwables.propagate((Throwable)e6);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)is);
        return keyAndCert;
    }
}

