/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.BaseRemoteProxy;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.DesiredCapabilities;

public class RegistrationServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = -8670670577712086527L;
    private static final Logger log = Logger.getLogger(RegistrationServlet.class.getName());

    public RegistrationServlet() {
        this(null);
    }

    public RegistrationServlet(GridRegistry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RegistrationRequest registrationRequest;
        String requestJsonString;
        try (BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));){
            requestJsonString = CharStreams.toString((Readable)rd);
        }
        log.fine("getting the following registration request  : " + requestJsonString);
        JsonObject json = new JsonParser().parse(requestJsonString).getAsJsonObject();
        if (!json.has("configuration")) {
            throw new GridConfigurationException("No configuration received for proxy.");
        }
        if (this.isV2RegistrationRequestJson(json)) {
            GridNodeConfiguration nodeConfiguration = this.mapV2Configuration(json.getAsJsonObject("configuration"));
            registrationRequest = new RegistrationRequest(nodeConfiguration);
            this.considerV2Json(registrationRequest.getConfiguration(), json);
        } else {
            registrationRequest = RegistrationRequest.fromJson(json);
        }
        Object proxy = BaseRemoteProxy.getNewInstance(registrationRequest, this.getRegistry());
        this.reply(response, "ok");
        new Thread(() -> {
            this.getRegistry().add((RemoteProxy)proxy);
            log.fine("proxy added " + proxy.getRemoteHost());
        }).start();
    }

    @Deprecated
    private GridNodeConfiguration mapV2Configuration(JsonObject json) {
        JsonElement servlets;
        JsonElement jsonElement = servlets = json.has("servlets") ? json.get("servlets") : null;
        if (servlets != null && servlets.isJsonPrimitive()) {
            json.remove("servlets");
        }
        GridNodeConfiguration pendingConfiguration = GridNodeConfiguration.loadFromJSON(json);
        if (servlets != null && servlets.isJsonPrimitive() && (pendingConfiguration.servlets == null || pendingConfiguration.servlets.isEmpty())) {
            pendingConfiguration.servlets = Lists.newArrayList((Object[])servlets.getAsString().split(","));
        }
        return pendingConfiguration;
    }

    @Deprecated
    private boolean isV2RegistrationRequestJson(JsonObject json) {
        return json.has("capabilities") && json.has("configuration");
    }

    @Deprecated
    private void considerV2Json(GridNodeConfiguration configuration, JsonObject json) {
        if (json.has("id")) {
            configuration.id = json.get("id").getAsString();
        }
        if (json.has("capabilities")) {
            configuration.capabilities.clear();
            JsonArray capabilities = json.get("capabilities").getAsJsonArray();
            Json converter = new Json();
            for (int i = 0; i < capabilities.size(); ++i) {
                MutableCapabilities cap = (MutableCapabilities)converter.toType((Object)capabilities.get(i), DesiredCapabilities.class);
                configuration.capabilities.add(cap);
            }
            configuration.fixUpCapabilities();
        }
    }

    protected void reply(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        response.getWriter().print(content);
    }
}

