/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.cli;

import com.beust.jcommander.Parameter;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;

public abstract class CommonCliOptions {
    @Parameter(names={"--version", "-version"}, description="Displays the version and exits.")
    public Boolean version = false;
    @Parameter(names={"--help", "-help", "-h"}, help=true, hidden=true, description="Displays this help.")
    public Boolean help = false;
    @Parameter(names={"--debug", "-debug"}, description="<Boolean> : enables LogLevel.FINE.")
    private Boolean debug = false;
    @Parameter(names={"-log"}, description="<String> filename : the filename to use for logging. If omitted, will log to STDOUT")
    private String log;
    @Parameter(names={"-role"}, description="<String> options are [hub], [node], or [standalone].")
    private String role;
    @Parameter(names={"-host"}, description="<String> IP or hostname : usually determined automatically. Most commonly useful in exotic network configurations (e.g. network with VPN)")
    private String host;
    @Parameter(names={"-port"}, description="<Integer> : the port number the server will use.")
    private Integer port;
    @Parameter(names={"-timeout", "-sessionTimeout"}, description="<Integer> in seconds : Specifies the timeout before the server automatically kills a session that hasn't had any activity in the last X seconds. The test slot will then be released for another test to use. This is typically used to take care of client crashes. For grid hub/node roles, cleanUpCycle must also be set.")
    private Integer timeout;
    @Parameter(names={"-browserTimeout"}, description="<Integer> in seconds : number of seconds a browser session is allowed to hang while a WebDriver command is running (example: driver.get(url)). If the timeout is reached while a WebDriver command is still processing, the session will quit. Minimum value is 60. An unspecified, zero, or negative value means wait indefinitely.")
    private Integer browserTimeout;
    @Parameter(names={"-avoidProxy"}, description="DO NOT USE: Hack to allow selenium 3.0 server run in SauceLabs", hidden=true)
    private Boolean avoidProxy;
    @Parameter(names={"-jettyThreads", "-jettyMaxThreads"}, description="<Integer> : max number of threads for Jetty. An unspecified, zero, or negative value means the Jetty default value (200) will be used.")
    private Integer jettyMaxThreads;
    @Parameter(names={"-browserSideLog"}, description="DO NOT USE: Provided for compatibility with 2.0", hidden=true)
    private Boolean browserSideLog = false;
    @Parameter(names={"-captureLogsOnQuit"}, description="DO NOT USE: Provided for compatibility with 2.0", hidden=true)
    private Boolean captureLogsOnQuit = false;

    void fillCommonConfiguration(StandaloneConfiguration configuration) {
        if (this.debug != null) {
            configuration.debug = this.debug;
        }
        if (this.log != null) {
            configuration.log = this.log;
        }
        if (this.host == null) {
            this.host = "0.0.0.0";
        }
        configuration.host = this.host;
        if (this.port != null) {
            configuration.port = this.port;
        }
        if (this.timeout != null) {
            configuration.timeout = this.timeout;
        }
        if (this.browserTimeout != null) {
            configuration.browserTimeout = this.browserTimeout;
        }
    }

    public abstract StandaloneConfiguration toConfiguration();
}

