/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.injector;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openqa.selenium.injector.UnableToInstaniateInstanceException;

public class Injector {
    private static final int MAGIC_SIZE = 100;
    private final Injector parent;
    private final ImmutableSet<Object> injectables;
    private final Map<Class<?>, Object> seenMappings;

    private Injector(Injector parent, Set<Object> injectables) {
        this.parent = parent;
        this.injectables = ImmutableSet.copyOf(injectables);
        this.seenMappings = new LinkedHashMap<Class<?>, Object>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Class<?>, Object> eldest) {
                return this.size() > 100;
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T newInstance(Class<T> stereotype) {
        try {
            class ConstructorAndArgs {
                public Constructor<?> constructor;
                public List<Object> args;

                public ConstructorAndArgs(Constructor<?> constructor, List<Object> args) {
                    this.constructor = constructor;
                    this.args = args;
                }
            }
            Optional<ConstructorAndArgs> possibleConstructor = Stream.of(stereotype.getDeclaredConstructors()).map(con -> new ConstructorAndArgs((Constructor<?>)con, this.populateArgs((Constructor<?>)con))).filter(canda -> canda.args != null).max(Comparator.comparing(canda -> canda.args.size()));
            if (!possibleConstructor.isPresent()) {
                throw new UnableToInstaniateInstanceException("Unable to find required matches for constructor of: " + stereotype);
            }
            ConstructorAndArgs canda2 = possibleConstructor.get();
            canda2.constructor.setAccessible(true);
            return (T)canda2.constructor.newInstance(canda2.args.toArray());
        }
        catch (ReflectiveOperationException e) {
            throw new UnableToInstaniateInstanceException(e);
        }
    }

    private List<Object> populateArgs(Constructor<?> constructor) {
        ArrayList<Object> toReturn = new ArrayList<Object>(constructor.getParameterCount());
        for (Parameter param : constructor.getParameters()) {
            Object value = this.findArg(param.getType());
            if (value == null) {
                return null;
            }
            toReturn.add(value);
        }
        return toReturn;
    }

    private Object findArg(Class<?> parameterType) {
        Optional<Object> possibleMatch = this.injectables.stream().filter(obj -> parameterType.isAssignableFrom(obj.getClass())).findFirst();
        if (possibleMatch.isPresent()) {
            this.seenMappings.put(parameterType, possibleMatch.get());
            return possibleMatch.get();
        }
        return this.parent == null ? null : this.parent.findArg(parameterType);
    }

    public static class Builder {
        private Injector parent;
        private final Set<Object> registered = new HashSet<Object>();
        private final Set<Class<?>> registeredClasses = new HashSet();

        private Builder() {
        }

        public Builder register(Object object) {
            Objects.requireNonNull(object);
            if (this.registeredClasses.contains(object.getClass())) {
                throw new IllegalArgumentException(String.format("Only one instance of a particular class is supported. Duplicate instance of %s is added: %s", object.getClass(), object));
            }
            this.registered.add(object);
            this.registeredClasses.add(object.getClass());
            return this;
        }

        public Builder parent(Injector parent) {
            if (this.parent != null) {
                throw new IllegalStateException("Injectors may only have one parent");
            }
            this.parent = Objects.requireNonNull(parent);
            return this;
        }

        public Injector build() {
            return new Injector(this.parent, this.registered);
        }
    }
}

