/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.DefaultDriverProvider;
import org.openqa.selenium.remote.server.DriverProvider;
import org.openqa.selenium.remote.server.InMemorySession;
import org.openqa.selenium.remote.server.ServicedSession;
import org.openqa.selenium.remote.server.SessionFactory;

public class ActiveSessionFactory
implements SessionFactory {
    private static final Logger LOG = Logger.getLogger(ActiveSessionFactory.class.getName());
    private static final Function<String, Class<?>> CLASS_EXISTS = name -> {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    };
    private volatile List<SessionFactory> factories;

    public ActiveSessionFactory() {
        ImmutableList.Builder builder = ImmutableList.builder();
        StreamSupport.stream(this.loadDriverProviders().spliterator(), false).forEach(p -> builder.add((Object)new InMemorySession.Factory((DriverProvider)p)));
        ImmutableMap.builder().put(caps -> {
            Object marionette = caps.getCapability("marionette");
            return marionette instanceof Boolean && (Boolean)marionette == false;
        }, (Object)"org.openqa.selenium.firefox.XpiDriverService").put(ActiveSessionFactory.browserName("chrome"), (Object)"org.openqa.selenium.chrome.ChromeDriverService").put(ActiveSessionFactory.containsKey("chromeOptions"), (Object)"org.openqa.selenium.chrome.ChromeDriverService").put(ActiveSessionFactory.browserName("MicrosoftEdge"), (Object)"org.openqa.selenium.edge.EdgeDriverService").put(ActiveSessionFactory.containsKey("edgeOptions"), (Object)"org.openqa.selenium.edge.EdgeDriverService").put(ActiveSessionFactory.browserName("firefox"), (Object)"org.openqa.selenium.firefox.GeckoDriverService").put(ActiveSessionFactory.containsKey(Pattern.compile("^moz:.*")), (Object)"org.openqa.selenium.firefox.GeckoDriverService").put(ActiveSessionFactory.browserName("internet explorer"), (Object)"org.openqa.selenium.ie.InternetExplorerDriverService").put(ActiveSessionFactory.containsKey("se:ieOptions"), (Object)"org.openqa.selenium.ie.InternetExplorerDriverService").put(ActiveSessionFactory.browserName("opera"), (Object)"org.openqa.selenium.opera.OperaDriverService").put(ActiveSessionFactory.browserName("operablink"), (Object)"org.openqa.selenium.opera.OperaDriverService").put(ActiveSessionFactory.browserName("phantomjs"), (Object)"org.openqa.selenium.phantomjs.PhantomJSDriverService").put(ActiveSessionFactory.browserName("safari"), (Object)"org.openqa.selenium.safari.SafariDriverService").put(ActiveSessionFactory.containsKey(Pattern.compile("^safari\\..*")), (Object)"org.openqa.selenium.safari.SafariDriverService").build().entrySet().stream().filter(e -> CLASS_EXISTS.apply((String)e.getValue()) != null).forEach(e -> builder.add((Object)new ServicedSession.Factory((Predicate)e.getKey(), (String)e.getValue())));
        this.bind((ImmutableList.Builder<SessionFactory>)builder, "org.openqa.selenium.htmlunit.HtmlUnitDriver", ActiveSessionFactory.browserName("htmlunit"), (Capabilities)new ImmutableCapabilities("browserName", (Object)"htmlunit"));
        this.factories = builder.build();
    }

    public synchronized ActiveSessionFactory bind(Predicate<Capabilities> onThis, SessionFactory useThis) {
        Objects.requireNonNull(onThis, "Predicated needed.");
        Objects.requireNonNull(useThis, "SessionFactory is required");
        LOG.info(String.format("Binding %s to respond to %s", useThis, onThis));
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)useThis);
        builder.addAll(this.factories);
        this.factories = builder.build();
        return this;
    }

    @VisibleForTesting
    protected Iterable<DriverProvider> loadDriverProviders() {
        return () -> ServiceLoader.load(DriverProvider.class).iterator();
    }

    private void bind(ImmutableList.Builder<SessionFactory> builder, String className, Predicate<Capabilities> predicate, Capabilities capabilities) {
        try {
            Class<?> clazz = CLASS_EXISTS.apply(className);
            if (clazz == null) {
                return;
            }
            Class<WebDriver> driverClass = clazz.asSubclass(WebDriver.class);
            builder.add((Object)new InMemorySession.Factory(new DefaultDriverProvider(capabilities, driverClass)));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static Predicate<Capabilities> browserName(String browserName) {
        Objects.requireNonNull(browserName, "Browser name must be set");
        return toCompare -> browserName.equals(toCompare.getBrowserName());
    }

    private static Predicate<Capabilities> containsKey(String keyName) {
        Objects.requireNonNull(keyName, "Key name must be set");
        return toCompare -> toCompare.getCapability(keyName) != null;
    }

    private static Predicate<Capabilities> containsKey(Pattern pattern) {
        return toCompare -> toCompare.asMap().keySet().stream().anyMatch(pattern.asPredicate());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.factories.stream().map(factory -> factory.isSupporting(capabilities)).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public Optional<ActiveSession> apply(Set<Dialect> downstreamDialects, Capabilities caps) {
        LOG.info("Capabilities are: " + new Json().toJson((Object)caps));
        return this.factories.stream().filter(factory -> factory.isSupporting(caps)).peek(factory -> LOG.info(String.format("Matched factory %s", factory))).map(factory -> factory.apply(downstreamDialects, caps)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

