/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class SetWindowSize
extends WebDriverHandler<Void> {
    private Dimension size;

    public SetWindowSize(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        int height;
        int width;
        super.setJsonParameters(allParameters);
        try {
            width = ((Number)allParameters.get("width")).intValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) window width value passed: " + allParameters.get("width"), (Throwable)ex);
        }
        try {
            height = ((Number)allParameters.get("height")).intValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) window height value passed: " + allParameters.get("height"), (Throwable)ex);
        }
        this.size = new Dimension(width, height);
    }

    @Override
    public Void call() throws Exception {
        this.getDriver().manage().window().setSize(this.size);
        return null;
    }

    public String toString() {
        return "[set window size]";
    }
}

