/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ErrorHandler
implements CommandHandler {
    private static final ErrorCodes errors = new ErrorCodes();
    private final Json json;
    private final Throwable throwable;

    public ErrorHandler(Json json, Throwable throwable) {
        this.json = Objects.requireNonNull(json);
        this.throwable = Objects.requireNonNull(throwable);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) {
        resp.setStatus(500);
        resp.setHeader("Cache-Control", "none");
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        ImmutableMap value = ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"message", (Object)this.throwable.getMessage(), (Object)"error", (Object)errors.toState(Integer.valueOf(errors.toStatusCode(this.throwable))), (Object)"stacktrace", (Object)Throwables.getStackTraceAsString((Throwable)this.throwable), (Object)"class", (Object)this.throwable.getClass().getName(), (Object)"stackTrace", (Object)this.throwable.getStackTrace()));
        resp.setContent(this.json.toJson((Object)value).getBytes(StandardCharsets.UTF_8));
    }
}

