/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.SessionCodec;
import org.openqa.selenium.remote.server.TeeReader;

class Passthrough
implements SessionCodec {
    private static final Logger LOG = Logger.getLogger(Passthrough.class.getName());
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ImmutableSet.builder().add((Object)"connection").add((Object)"keep-alive").add((Object)"proxy-authorization").add((Object)"proxy-authenticate").add((Object)"proxy-connection").add((Object)"te").add((Object)"trailer").add((Object)"transfer-encoding").add((Object)"upgrade").build();
    private final URL upstream;

    public Passthrough(URL upstream) {
        this.upstream = upstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpRequest req, HttpResponse resp) throws IOException {
        URL target = new URL(this.upstream.toExternalForm() + req.getUri());
        HttpURLConnection connection = (HttpURLConnection)target.openConnection();
        connection.setInstanceFollowRedirects(true);
        connection.setRequestMethod(req.getMethod().toString());
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        for (String name : req.getHeaderNames()) {
            if (IGNORED_REQ_HEADERS.contains((Object)name.toLowerCase())) continue;
            for (String value : req.getHeaders(name)) {
                connection.addRequestProperty(name, value);
            }
        }
        connection.setRequestProperty("Connection", "close");
        if (HttpMethod.POST == req.getMethod()) {
            String contentType = req.getHeader("Content-Type");
            contentType = contentType == null ? MediaType.JSON_UTF_8.toString() : contentType;
            MediaType type = MediaType.parse((String)contentType);
            connection.setRequestProperty("Content-Type", type.withCharset(StandardCharsets.UTF_8).toString());
            Charset charSet = req.getContentEncoding();
            StringWriter logWriter = new StringWriter();
            try (InputStream is = req.consumeContentStream();
                 InputStreamReader reader = new InputStreamReader(is, charSet);
                 TeeReader in = new TeeReader(reader, logWriter);
                 OutputStream os = connection.getOutputStream();
                 OutputStreamWriter out = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
                CharStreams.copy((Readable)in, (Appendable)out);
            }
            LOG.info("To upstream: " + logWriter.toString());
        }
        resp.setStatus(connection.getResponseCode());
        resp.setHeader("Date", null);
        resp.setHeader("Server", null);
        connection.getHeaderFields().entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).filter(entry -> !IGNORED_REQ_HEADERS.contains((Object)((String)entry.getKey()).toLowerCase())).forEach(entry -> ((List)entry.getValue()).stream().filter(Objects::nonNull).forEach(value -> resp.addHeader((String)entry.getKey(), value)));
        InputStream in = connection.getErrorStream();
        if (in == null) {
            in = connection.getInputStream();
        }
        String charSet = connection.getContentEncoding() != null ? connection.getContentEncoding() : StandardCharsets.UTF_8.name();
        try (InputStreamReader reader = new InputStreamReader(in, charSet);){
            String content = CharStreams.toString((Readable)reader);
            LOG.info("To downstream: " + content);
            resp.setContent(content.getBytes(charSet));
        }
        finally {
            in.close();
        }
    }
}

