/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.beust.jcommander.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.internal.utils.configuration.converters.BrowserDesiredCapabilityConverter;
import org.openqa.grid.internal.utils.configuration.converters.NoOpParameterSplitter;
import org.openqa.grid.internal.utils.configuration.validators.FileExistsValueValidator;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class GridNodeConfiguration
extends GridConfiguration {
    public static final String DEFAULT_NODE_CONFIG_FILE = "defaults/DefaultNodeWebDriver.json";
    public static final String CONFIG_UUID_CAPABILITY = "se:CONFIG_UUID";
    static final String DEFAULT_ROLE = "node";
    static final Integer DEFAULT_PORT = 5555;
    static final Integer DEFAULT_POLLING_INTERVAL = 5000;
    static final Integer DEFAULT_MAX_SESSION = 5;
    static final Integer DEFAULT_REGISTER_CYCLE = 5000;
    static final Boolean DEFAULT_REGISTER_TOGGLE = true;
    static final String DEFAULT_HUB = "http://localhost:4444";
    static final Integer DEFAULT_NODE_STATUS_CHECK_TIMEOUT = 5000;
    static final Integer DEFAULT_UNREGISTER_DELAY = 60000;
    static final Integer DEFAULT_DOWN_POLLING_LIMIT = 2;
    static final String DEFAULT_PROXY = "org.openqa.grid.selenium.proxy.DefaultRemoteProxy";
    private HostPort hubHostPort;
    @Parameter(names={"-nodeConfig"}, description="<String> filename : JSON configuration file for the node. Overrides default values", validateValueWith={FileExistsValueValidator.class})
    public String nodeConfigFile;
    @Expose
    @Parameter(names={"-remoteHost"}, description="<String> URL: Address to report to the hub. Used to override default (http://<host>:<port>).")
    String remoteHost;
    @Expose(serialize=false)
    @Deprecated
    private Object configuration;
    @Expose
    @Parameter(names={"-hubHost"}, description="<String> IP or hostname : the host address of the hub we're attempting to register with. If -hub is specified the -hubHost is determined from it.")
    String hubHost;
    @Expose
    @Parameter(names={"-hubPort"}, description="<Integer> : the port of the hub we're attempting to register with. If -hub is specified the -hubPort is determined from it.")
    Integer hubPort;
    @Expose
    @Parameter(names={"-id"}, description="<String> : optional unique identifier for the node. Defaults to the url of the remoteHost, when not specified.")
    public String id;
    @Expose
    @Parameter(names={"-capabilities", "-browser"}, description="<String> : comma separated Capability values. Example: -capabilities browserName=firefox,platform=linux -capabilities browserName=chrome,platform=linux", listConverter=BrowserDesiredCapabilityConverter.class, converter=BrowserDesiredCapabilityConverter.class, splitter=NoOpParameterSplitter.class)
    public List<MutableCapabilities> capabilities = DefaultDesiredCapabilitiesBuilder.getCapabilities();
    @Expose
    @Parameter(names={"-downPollingLimit"}, description="<Integer> : node is marked as \"down\" if the node hasn't responded after the number of checks specified in [downPollingLimit].")
    public Integer downPollingLimit = DEFAULT_DOWN_POLLING_LIMIT;
    @Parameter(names={"-hub"}, description="<String> : the url that will be used to post the registration request. This option takes precedence over -hubHost and -hubPort options.")
    private String hubOption;
    @Expose
    public String hub = "http://localhost:4444";
    @Expose
    @Parameter(names={"-nodePolling"}, description="<Integer> in ms : specifies how often the hub will poll to see if the node is still responding.")
    public Integer nodePolling = DEFAULT_POLLING_INTERVAL;
    @Expose
    @Parameter(names={"-nodeStatusCheckTimeout"}, description="<Integer> in ms : connection/socket timeout, used for node \"nodePolling\" check.")
    public Integer nodeStatusCheckTimeout = DEFAULT_NODE_STATUS_CHECK_TIMEOUT;
    @Expose
    @Parameter(names={"-proxy"}, description="<String> : the class used to represent the node proxy. Default is [org.openqa.grid.selenium.proxy.DefaultRemoteProxy].")
    public String proxy = "org.openqa.grid.selenium.proxy.DefaultRemoteProxy";
    @Expose
    @Parameter(names={"-register"}, description="if specified, node will attempt to re-register itself automatically with its known grid hub if the hub becomes unavailable.", arity=1)
    public Boolean register = DEFAULT_REGISTER_TOGGLE;
    @Expose
    @Parameter(names={"-registerCycle"}, description="<Integer> in ms : specifies how often the node will try to register itself again. Allows administrator to restart the hub without restarting (or risk orphaning) registered nodes. Must be specified with the \"-register\" option.")
    public Integer registerCycle = DEFAULT_REGISTER_CYCLE;
    @Expose
    @Parameter(names={"-unregisterIfStillDownAfter"}, description="<Integer> in ms : if the node remains down for more than [unregisterIfStillDownAfter] ms, it will stop attempting to re-register from the hub.")
    public Integer unregisterIfStillDownAfter = DEFAULT_UNREGISTER_DELAY;
    @Expose
    @Parameter(names={"-enablePlatformVerification"}, arity=1, description="<Boolean>: Whether or not to drop capabilities that does not belong to the current platform family. Defaults to true.")
    public boolean enablePlatformVerification = true;

    public GridNodeConfiguration() {
        this.role = DEFAULT_ROLE;
        this.port = DEFAULT_PORT;
        this.maxSession = DEFAULT_MAX_SESSION;
    }

    public String getHubHost() {
        return this.getHubHostPort().host;
    }

    public Integer getHubPort() {
        return this.getHubHostPort().port;
    }

    private HostPort getHubHostPort() {
        if (this.hubHostPort == null) {
            if (this.hubOption != null) {
                this.hub = this.hubOption;
                try {
                    URL u = new URL(this.hub);
                    this.hubHostPort = new HostPort(u.getHost(), u.getPort());
                }
                catch (MalformedURLException mURLe) {
                    throw new RuntimeException("-hub must be a valid url: " + this.hub, mURLe);
                }
            }
            if (this.hubHost != null || this.hubPort != null) {
                if (this.hubHost == null) {
                    throw new RuntimeException("You must specify either a -hubHost or -hub parameter.");
                }
                if (this.hubPort == null) {
                    throw new RuntimeException("You must specify either a -hubPort or -hub parameter.");
                }
                this.hubHostPort = new HostPort(this.hubHost, this.hubPort);
            } else {
                try {
                    URL u = new URL(this.hub);
                    this.hubHostPort = new HostPort(u.getHost(), u.getPort());
                }
                catch (MalformedURLException mURLe) {
                    throw new RuntimeException("-hub must be a valid url: " + this.hub, mURLe);
                }
            }
        }
        return this.hubHostPort;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (this.host == null) {
                this.host = "localhost";
            }
            if (this.port == null) {
                this.port = 5555;
            }
            this.remoteHost = "http://" + this.host + ":" + this.port;
        }
        return this.remoteHost;
    }

    public void merge(GridNodeConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(other.capabilities, this.capabilities)) {
            this.capabilities = other.capabilities;
        }
        if (this.isMergeAble(other.downPollingLimit, this.downPollingLimit)) {
            this.downPollingLimit = other.downPollingLimit;
        }
        if (this.isMergeAble(other.hubOption, this.hubOption)) {
            this.hubOption = other.hubOption;
        }
        if (this.isMergeAble(other.hubHost, this.hubHost)) {
            this.hubHost = other.hubHost;
        }
        if (this.isMergeAble(other.hubPort, this.hubPort)) {
            this.hubPort = other.hubPort;
        }
        if (this.isMergeAble(other.id, this.id)) {
            this.id = other.id;
        }
        if (this.isMergeAble(other.nodePolling, this.nodePolling)) {
            this.nodePolling = other.nodePolling;
        }
        if (this.isMergeAble(other.nodeStatusCheckTimeout, this.nodeStatusCheckTimeout)) {
            this.nodeStatusCheckTimeout = other.nodeStatusCheckTimeout;
        }
        if (this.isMergeAble(other.proxy, this.proxy)) {
            this.proxy = other.proxy;
        }
        if (this.isMergeAble(other.register, this.register)) {
            this.register = other.register;
        }
        if (this.isMergeAble(other.registerCycle, this.registerCycle)) {
            this.registerCycle = other.registerCycle;
        }
        if (this.isMergeAble(other.remoteHost, this.remoteHost)) {
            this.remoteHost = other.remoteHost;
        }
        if (this.isMergeAble(other.unregisterIfStillDownAfter, this.unregisterIfStillDownAfter)) {
            this.unregisterIfStillDownAfter = other.unregisterIfStillDownAfter;
        }
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "capabilities", this.capabilities));
        sb.append((CharSequence)this.toString(format, "downPollingLimit", this.downPollingLimit));
        sb.append((CharSequence)this.toString(format, "hub", this.hub));
        sb.append((CharSequence)this.toString(format, "id", this.id));
        sb.append((CharSequence)this.toString(format, "hubHost", this.hubHost));
        sb.append((CharSequence)this.toString(format, "hubPort", this.hubPort));
        sb.append((CharSequence)this.toString(format, "nodeConfigFile", this.nodeConfigFile));
        sb.append((CharSequence)this.toString(format, "nodePolling", this.nodePolling));
        sb.append((CharSequence)this.toString(format, "nodeStatusCheckTimeout", this.nodeStatusCheckTimeout));
        sb.append((CharSequence)this.toString(format, "proxy", this.proxy));
        sb.append((CharSequence)this.toString(format, "register", this.register));
        sb.append((CharSequence)this.toString(format, "registerCycle", this.registerCycle));
        sb.append((CharSequence)this.toString(format, "remoteHost", this.remoteHost));
        sb.append((CharSequence)this.toString(format, "unregisterIfStillDownAfter", this.unregisterIfStillDownAfter));
        return sb.toString();
    }

    public static GridNodeConfiguration loadFromJSON(String filePath) {
        return GridNodeConfiguration.loadFromJSON(GridNodeConfiguration.loadJSONFromResourceOrFile(filePath));
    }

    public static GridNodeConfiguration loadFromJSON(JsonObject json) {
        try {
            GsonBuilder builder = new GsonBuilder();
            GridNodeConfiguration.staticAddJsonTypeAdapter(builder);
            GridNodeConfiguration config = (GridNodeConfiguration)builder.excludeFieldsWithoutExposeAnnotation().create().fromJson((JsonElement)json, GridNodeConfiguration.class);
            if (config.configuration != null) {
                throw new GridConfigurationException("Deprecated -nodeConfig file encountered. Please update the file to work with Selenium 3. See https://github.com/SeleniumHQ/selenium/wiki/Grid2#configuring-the-nodes-by-json for more details.");
            }
            return config;
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    @Override
    protected void addJsonTypeAdapter(GsonBuilder builder) {
        super.addJsonTypeAdapter(builder);
        GridNodeConfiguration.staticAddJsonTypeAdapter(builder);
    }

    protected static void staticAddJsonTypeAdapter(GsonBuilder builder) {
        builder.registerTypeAdapter(new TypeToken<List<MutableCapabilities>>(){}.getType(), (Object)new CollectionOfDesiredCapabilitiesSerializer());
        builder.registerTypeAdapter(new TypeToken<List<MutableCapabilities>>(){}.getType(), (Object)new CollectionOfDesiredCapabilitiesDeSerializer());
    }

    public void fixUpCapabilities() {
        if (this.capabilities == null) {
            return;
        }
        Platform current = Platform.getCurrent();
        this.capabilities = this.capabilities.stream().peek(cap -> cap.setCapability("platform", Optional.ofNullable(cap.getCapability("platformName")).orElse(Optional.ofNullable(cap.getCapability("platform")).orElse(current)))).peek(cap -> cap.setCapability("platformName", Optional.ofNullable(cap.getCapability("platformName")).orElse(Optional.ofNullable(cap.getCapability("platform")).orElse(current)))).peek(cap -> cap.setCapability("seleniumProtocol", Optional.ofNullable(cap.getCapability("seleniumProtocol")).orElse(SeleniumProtocol.WebDriver.toString()))).peek(cap -> cap.setCapability(CONFIG_UUID_CAPABILITY, UUID.randomUUID().toString())).collect(Collectors.toList());
    }

    public void dropCapabilitiesThatDoesNotMatchCurrentPlatform() {
        if (!this.enablePlatformVerification) {
            return;
        }
        if (this.capabilities == null) {
            return;
        }
        Platform current = Platform.getCurrent();
        Platform currentFamily = Optional.ofNullable(current.family()).orElse(current);
        this.capabilities = this.capabilities.stream().filter(cap -> cap.getPlatform() != null && (cap.getPlatform() == Platform.ANY || cap.getPlatform().is(currentFamily))).collect(Collectors.toList());
    }

    public void fixUpHost() {
        NetworkUtils util = new NetworkUtils();
        if (this.host == null || "ip".equalsIgnoreCase(this.host)) {
            this.host = util.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        } else if ("host".equalsIgnoreCase(this.host)) {
            this.host = util.getIp4NonLoopbackAddressOfThisMachine().getHostName();
        }
    }

    public static class CollectionOfDesiredCapabilitiesDeSerializer
    implements JsonDeserializer<List<MutableCapabilities>> {
        public List<MutableCapabilities> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonArray()) {
                ArrayList<MutableCapabilities> desiredCapabilities = new ArrayList<MutableCapabilities>();
                Json json = new Json();
                for (JsonElement arrayElement : jsonElement.getAsJsonArray()) {
                    desiredCapabilities.add((MutableCapabilities)json.toType((Object)arrayElement, DesiredCapabilities.class));
                }
                return desiredCapabilities;
            }
            throw new JsonParseException("capabilities should be expressed as an array of objects.");
        }
    }

    public static class CollectionOfDesiredCapabilitiesSerializer
    implements JsonSerializer<List<MutableCapabilities>> {
        public JsonElement serialize(List<MutableCapabilities> desiredCapabilities, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonArray capabilities = new JsonArray();
            Json json = new Json();
            for (MutableCapabilities dc : desiredCapabilities) {
                capabilities.add(json.toJsonElement((Object)dc));
            }
            return capabilities;
        }
    }

    private static class HostPort {
        final String host;
        final int port;

        HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    static final class DefaultDesiredCapabilitiesBuilder {
        DefaultDesiredCapabilitiesBuilder() {
        }

        static List<MutableCapabilities> getCapabilities() {
            JsonObject defaults = StandaloneConfiguration.loadJSONFromResourceOrFile(GridNodeConfiguration.DEFAULT_NODE_CONFIG_FILE);
            ArrayList<MutableCapabilities> caps = new ArrayList<MutableCapabilities>();
            for (JsonElement el : defaults.getAsJsonArray("capabilities")) {
                caps.add((MutableCapabilities)new Json().toType((Object)el, DesiredCapabilities.class));
            }
            return caps;
        }
    }
}

