/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ServletRequestWrappingHttpRequest;
import org.openqa.selenium.remote.server.ServletResponseWrappingHttpResponse;

public class ProxyStatusServlet
extends RegistryBasedServlet {
    private final Json json = new Json();

    public ProxyStatusServlet() {
        this(null);
    }

    public ProxyStatusServlet(GridRegistry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(new ServletRequestWrappingHttpRequest(request), new ServletResponseWrappingHttpResponse(response));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(new ServletRequestWrappingHttpRequest(request), new ServletResponseWrappingHttpResponse(response));
    }

    protected void process(HttpRequest request, HttpResponse response) throws IOException {
        response.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        response.setStatus(200);
        try {
            Map<String, Object> res = this.getResponse(request);
            response.setContent(this.json.toJson(res).getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable e) {
            throw new GridException(e.getMessage());
        }
    }

    private Map<String, Object> getResponse(HttpRequest request) throws IOException {
        String id;
        Map requestJson = null;
        if (!request.getContentString().isEmpty()) {
            requestJson = (Map)this.json.toType((Object)request.getContentString(), Json.MAP_TYPE);
        }
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        res.put("success", false);
        if (requestJson == null) {
            id = request.getQueryParameter("id");
        } else {
            if (!requestJson.containsKey("id")) {
                res.put("msg", "you need to specify at least an id when call the node status service.");
                return res;
            }
            id = String.valueOf(requestJson.get("id"));
        }
        try {
            URL u = new URL(id);
            id = "http://" + u.getHost() + ":" + u.getPort();
        }
        catch (MalformedURLException u) {
            // empty catch block
        }
        RemoteProxy proxy = this.getRegistry().getProxyById(id);
        if (proxy == null) {
            res.put("msg", "Cannot find proxy with ID =" + id + " in the registry.");
            return res;
        }
        res.put("msg", "proxy found !");
        res.put("success", true);
        res.put("id", proxy.getId());
        res.put("request", proxy.getOriginalRegistrationRequest());
        if (requestJson != null) {
            List<String> methods = this.getExtraMethodsRequested(requestJson);
            ArrayList<String> errors = new ArrayList<String>();
            for (String method : methods) {
                try {
                    Object o = this.getValueByReflection(proxy, method);
                    res.put(method, o);
                }
                catch (Throwable t) {
                    errors.add(t.getMessage());
                }
            }
            if (!errors.isEmpty()) {
                res.put("success", false);
                res.put("errors", ((Object)errors).toString());
            }
        }
        return res;
    }

    private Object getValueByReflection(RemoteProxy proxy, String method) {
        Class[] argsClass = new Class[]{};
        try {
            Method m = proxy.getClass().getDeclaredMethod(method, argsClass);
            return m.invoke((Object)proxy, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getClass() + " - " + e.getMessage());
        }
    }

    private List<String> getExtraMethodsRequested(Map<String, Object> request) {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : request.entrySet()) {
            if ("id".equals(entry.getKey())) continue;
            res.add(entry.getKey());
        }
        return res;
    }
}

