/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import java.util.Map;
import java.util.TreeMap;
import org.openqa.grid.common.GridConfiguredJson;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;

public class RegistrationRequest {
    public static final String MAX_INSTANCES = "maxInstances";
    public static final String SELENIUM_PROTOCOL = "seleniumProtocol";
    public static final String PATH = "path";
    private String name;
    private String description;
    private GridNodeConfiguration configuration;

    public RegistrationRequest() {
        this(new GridNodeConfiguration());
    }

    public RegistrationRequest(GridNodeConfiguration configuration) {
        this(configuration, null, null);
    }

    public RegistrationRequest(GridNodeConfiguration configuration, String name) {
        this(configuration, name, null);
    }

    public RegistrationRequest(GridNodeConfiguration configuration, String name, String description) {
        this.configuration = configuration == null ? new GridNodeConfiguration() : configuration;
        this.name = name;
        this.description = description;
        this.configuration.fixUpHost();
        this.configuration.fixUpCapabilities();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public GridNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, Object> toJson() {
        TreeMap<String, Object> json = new TreeMap<String, Object>();
        json.put("class", this.getClass());
        json.put("name", this.getName());
        json.put("description", this.getDescription());
        json.put("configuration", this.getConfiguration());
        return json;
    }

    public static RegistrationRequest fromJson(Map<String, Object> raw) throws JsonException {
        Json json = new Json();
        RegistrationRequest request = new RegistrationRequest();
        if (raw.get("name") instanceof String) {
            request.name = (String)raw.get("name");
        }
        if (raw.get("description") instanceof String) {
            request.description = (String)raw.get("description");
        }
        if (raw.get("configuration") instanceof Map) {
            String converted = json.toJson(raw.get("configuration"));
            request.configuration = (GridNodeConfiguration)GridConfiguredJson.toType(converted, GridNodeConfiguration.class);
        }
        if (raw.get("configuration") instanceof GridNodeConfiguration) {
            request.configuration = (GridNodeConfiguration)raw.get("configuration");
        }
        return request;
    }

    public static RegistrationRequest build() {
        return RegistrationRequest.build(new GridNodeConfiguration(), null, null);
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration) {
        return RegistrationRequest.build(configuration, null, null);
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration, String name) {
        return RegistrationRequest.build(configuration, name, null);
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration, String name, String description) {
        RegistrationRequest pendingRequest = new RegistrationRequest(configuration, name, description);
        GridNodeConfiguration pendingConfiguration = pendingRequest.configuration;
        if (pendingConfiguration.nodeConfigFile != null) {
            pendingRequest.configuration = GridNodeConfiguration.loadFromJSON(pendingConfiguration.nodeConfigFile);
        }
        pendingRequest.configuration.merge(pendingConfiguration);
        if (pendingConfiguration.host != null) {
            pendingRequest.configuration.host = pendingConfiguration.host;
        }
        if (pendingConfiguration.port != null) {
            pendingRequest.configuration.port = pendingConfiguration.port;
        }
        pendingRequest.configuration.fixUpHost();
        pendingRequest.configuration.fixUpCapabilities();
        pendingRequest.configuration.dropCapabilitiesThatDoesNotMatchCurrentPlatform();
        return pendingRequest;
    }

    public void validate() throws GridConfigurationException {
        try {
            this.configuration.getHubHost();
            this.configuration.getHubPort();
        }
        catch (RuntimeException e) {
            throw new GridConfigurationException(e.getMessage());
        }
    }
}

