/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openqa.grid.common.GridRole;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class DisplayHelpHandler
implements CommandHandler {
    private static Map<String, MediaType> TYPES = ImmutableMap.of((Object)".js", (Object)MediaType.JAVASCRIPT_UTF_8, (Object)".css", (Object)MediaType.CSS_UTF_8, (Object)".png", (Object)MediaType.PNG, (Object)".jpg", (Object)MediaType.JPEG, (Object)".ico", (Object)MediaType.ICO);
    private static final String HELPER_SERVLET_TEMPLATE = "displayhelpservlet.html";
    private static final String HELPER_SERVLET_ASSET_PATH_PREFIX = "/assets/";
    private static final String HELPER_SERVLET_RESOURCE_PATH = "org/openqa/grid/images/";
    private static final String HELPER_SERVLET_TEMPLATE_CONFIG_JSON_VAR = "${servletConfigJson}";
    private final Json json;
    private final GridRole role;
    private final DisplayHelpServletConfig servletConfig;

    public DisplayHelpHandler(Json json, GridRole role, String consolePath) {
        this.json = Objects.requireNonNull(json);
        this.role = Objects.requireNonNull(role);
        this.servletConfig = new DisplayHelpServletConfig(new BuildInfo().getReleaseLabel(), this.getHelperType(), consolePath);
    }

    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        block57: {
            String resource = req.getUri();
            if (resource.contains(HELPER_SERVLET_ASSET_PATH_PREFIX) && !resource.replace(HELPER_SERVLET_ASSET_PATH_PREFIX, "").contains("/") && !resource.replace(HELPER_SERVLET_ASSET_PATH_PREFIX, "").equals("")) {
                resource = resource.replace(HELPER_SERVLET_ASSET_PATH_PREFIX, "");
                int index = resource.lastIndexOf(46);
                MediaType type = MediaType.HTML_UTF_8;
                if (index != -1) {
                    String extension = resource.substring(index);
                    type = TYPES.getOrDefault(extension, MediaType.HTML_UTF_8);
                }
                resp.setHeader("Content-Type", type.toString());
                try (InputStream in = this.getResourceInputStream(resource);){
                    if (in == null) {
                        resp.setStatus(404);
                        return;
                    }
                    resp.setStatus(200);
                    resp.setContent(Contents.bytes((byte[])ByteStreams.toByteArray((InputStream)in)));
                    return;
                }
            }
            try (InputStream in = this.getResourceInputStream(HELPER_SERVLET_TEMPLATE);){
                String htmlTemplate;
                if (in == null) {
                    resp.setStatus(404);
                    break block57;
                }
                StringBuilder jsonBuilder = new StringBuilder();
                try (JsonOutput out = this.json.newOutput((Appendable)jsonBuilder);){
                    out.setPrettyPrint(false).write((Object)this.servletConfig);
                }
                String json = jsonBuilder.toString();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    htmlTemplate = reader.lines().collect(Collectors.joining("\n"));
                }
                String updatedTemplate = htmlTemplate.replace(HELPER_SERVLET_TEMPLATE_CONFIG_JSON_VAR, json);
                if (resource.equals("/")) {
                    resp.setStatus(200);
                } else {
                    resp.setStatus(404);
                }
                resp.setHeader("Content-Type", MediaType.HTML_UTF_8.toString());
                resp.setContent(Contents.utf8String((CharSequence)updatedTemplate));
            }
        }
    }

    @VisibleForTesting
    String getHelperType() {
        switch (this.role) {
            case HUB: {
                return "Grid Hub";
            }
            case NODE: {
                return "Grid Node";
            }
        }
        return "Standalone";
    }

    private InputStream getResourceInputStream(String resource) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(HELPER_SERVLET_RESOURCE_PATH + resource);
        if (in == null) {
            return null;
        }
        return in;
    }

    private final class DisplayHelpServletConfig {
        private final String version;
        private final String type;
        private final String consoleLink;

        public DisplayHelpServletConfig(String version, String type, String consoleLink) {
            this.version = Objects.requireNonNull(version);
            this.type = Objects.requireNonNull(type);
            this.consoleLink = Objects.requireNonNull(consoleLink);
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public String getConsoleLink() {
            return this.consoleLink;
        }
    }
}

