/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class NodeSessionsServlet
extends RegistryBasedServlet {
    private final Json json = new Json();

    public NodeSessionsServlet() {
        this(null);
    }

    public NodeSessionsServlet(GridRegistry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        this.process(rsp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.process(resp);
    }

    protected void process(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        TreeMap<String, Object> proxies = new TreeMap<String, Object>();
        try (PrintWriter writer = response.getWriter();
             JsonOutput out = this.json.newOutput((Appendable)writer);){
            proxies.put("success", true);
            proxies.put("proxies", this.extractSessionsFromAllProxies());
            out.write(proxies);
        }
    }

    private List<Map<String, Object>> extractSessionsFromAllProxies() {
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        List<RemoteProxy> proxies = this.getRegistry().getAllProxies().getBusyProxies();
        for (RemoteProxy proxy : proxies) {
            TreeMap<String, Object> res = new TreeMap<String, Object>();
            res.put("id", proxy.getId());
            res.put("remoteHost", proxy.getRemoteHost().toString());
            TreeMap<String, Object> sessionsInProxy = new TreeMap<String, Object>(this.extractSessionInfo(proxy));
            if (sessionsInProxy.isEmpty()) {
                sessionsInProxy.put("success", false);
            }
            res.put("sessions", sessionsInProxy);
            results.add(res);
        }
        return results;
    }

    /*
     * Loose catch block
     */
    private Map<String, Object> extractSessionInfo(RemoteProxy proxy) {
        Map map;
        Throwable throwable;
        JsonInput jsonReader;
        Throwable throwable2;
        Reader reader;
        block31: {
            block32: {
                block29: {
                    block30: {
                        URL url = proxy.getRemoteHost();
                        HttpRequest req = new HttpRequest(HttpMethod.GET, "/wd/hub/sessions");
                        Integer nodeStatusCheckTimeout = proxy.getConfig().nodeStatusCheckTimeout;
                        HttpResponse rsp = proxy.getHttpClient(url, nodeStatusCheckTimeout, nodeStatusCheckTimeout).execute(req);
                        reader = Contents.reader((HttpMessage)rsp);
                        throwable2 = null;
                        jsonReader = this.json.newInput(reader);
                        throwable = null;
                        map = (Map)jsonReader.read(Json.MAP_TYPE);
                        if (jsonReader == null) break block29;
                        if (throwable == null) break block30;
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block29;
                    }
                    jsonReader.close();
                }
                if (reader == null) break block31;
                if (throwable2 == null) break block32;
                try {
                    reader.close();
                }
                catch (Throwable throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                break block31;
            }
            reader.close();
        }
        return map;
        {
            catch (Throwable throwable5) {
                try {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    if (jsonReader != null) {
                                        if (throwable != null) {
                                            try {
                                                jsonReader.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            jsonReader.close();
                                        }
                                    }
                                    throw throwable6;
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable2 = throwable8;
                                throw throwable8;
                            }
                        }
                        catch (Throwable throwable9) {
                            if (reader != null) {
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable2.addSuppressed(throwable10);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw throwable9;
                        }
                    }
                    catch (JsonException jsonException) {
                    }
                }
                catch (IOException e) {
                    throw new GridException(e.getMessage());
                }
            }
        }
        return new TreeMap<String, Object>();
    }
}

