/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 7253742807937667039L;
    private static final ImmutableMap<String, MediaType> MIME_TYPES = ImmutableMap.of((Object)"css", (Object)MediaType.CSS_UTF_8.withoutParameters(), (Object)"html", (Object)MediaType.HTML_UTF_8.withoutParameters(), (Object)"js", (Object)MediaType.JAVASCRIPT_UTF_8.withoutParameters());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        InputStream in;
        String resource = request.getPathInfo().replace(request.getServletPath(), "");
        if (resource.startsWith("/")) {
            resource = resource.replaceFirst("/", "");
        }
        if ((in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource)) == null) {
            throw new Error("Cannot find resource " + resource);
        }
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        finally {
            in.close();
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, 10);
            response.setDateHeader("Expires", c.getTime().getTime());
            response.setHeader("Cache-Control", "max-age=864000");
            String extension = Files.getFileExtension((String)resource);
            if (MIME_TYPES.containsKey((Object)extension)) {
                response.setContentType(((MediaType)MIME_TYPES.get((Object)extension)).toString());
            }
            response.flushBuffer();
        }
    }
}

