/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.handler.internal.ArgumentConverter;

public class SwitchToFrame
extends WebDriverHandler<Void> {
    private volatile Object id;

    public SwitchToFrame(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        this.id = new ArgumentConverter(this.getKnownElements()).apply(allParameters.get("id"));
    }

    @Override
    public Void call() {
        if (this.id == null) {
            this.getDriver().switchTo().defaultContent();
        } else if (this.id instanceof Number) {
            this.getDriver().switchTo().frame(((Number)this.id).intValue());
        } else if (this.id instanceof WebElement) {
            this.getDriver().switchTo().frame((WebElement)this.id);
        } else if (this.id instanceof String) {
            this.getDriver().switchTo().frame((String)this.id);
        } else {
            throw new IllegalArgumentException("Unsupported frame locator: " + this.id.getClass().getName());
        }
        return null;
    }

    public String toString() {
        return String.format("[switch to frame: %s]", this.id == null ? "default" : this.id);
    }
}

