/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.redis;

import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import java.io.Closeable;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.redisson.Redisson;
import org.redisson.api.RLiveObjectService;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

public class GridRedisClient
implements Closeable {
    private final RedisClient client;
    private final RedissonClient redissonClient;
    private final StatefulRedisConnection<String, String> connection;
    private final RLiveObjectService service;

    public GridRedisClient(URI serverUri) {
        this.client = RedisClient.create((RedisURI)RedisURI.create((URI)serverUri));
        this.connection = this.client.connect();
        Config redissonConfig = new Config();
        redissonConfig.setNettyThreads(0);
        SingleServerConfig singleServerConfig = redissonConfig.useSingleServer();
        singleServerConfig.setAddress(serverUri.toString());
        singleServerConfig.setConnectionMinimumIdleSize(5);
        singleServerConfig.setConnectionPoolSize(5);
        this.redissonClient = Redisson.create((Config)redissonConfig);
        this.service = this.redissonClient.getLiveObjectService();
    }

    public StatefulRedisConnection<String, String> getConnection() {
        return this.connection;
    }

    public void mset(Map<String, String> map) {
        this.connection.sync().mset(map);
    }

    public List<KeyValue<String, String>> mget(String ... keys) {
        return this.connection.sync().mget((Object[])keys);
    }

    public String get(String key) {
        return (String)this.connection.sync().get((Object)key);
    }

    public List<String> getKeysByPattern(String pattern) {
        return this.connection.sync().keys((Object)pattern);
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public void del(String ... var1) {
        this.connection.sync().del((Object[])var1);
    }

    @Override
    public void close() {
        this.client.shutdown();
        this.redissonClient.shutdown();
    }

    public void addNodeAvailability(Availability availability, NodeStatus node) {
        RSet nodeAvailabilitySet = this.redissonClient.getSet(availability.name());
        nodeAvailabilitySet.add((Object)node.getNodeId());
    }

    public void removeNodeAvailability(Availability availability, NodeStatus node) {
        RSet nodeAvailabilitySet = this.redissonClient.getSet(availability.name());
        nodeAvailabilitySet.remove((Object)node.getNodeId());
    }

    public void addAllNodeAvailability(Availability availability, Set<NodeId> nodes) {
        RSet nodeAvailabilitySet = this.redissonClient.getSet(availability.name());
        nodeAvailabilitySet.addAll(nodes);
    }

    public void removeAllNodeAvailability(Availability availability, Set<NodeId> nodes) {
        RSet nodeAvailabilitySet = this.redissonClient.getSet(availability.name());
        nodeAvailabilitySet.removeAll(nodes);
    }

    public boolean getNodeAvailability(Availability availability, NodeId id) {
        RSet nodeAvailabilitySet = this.redissonClient.getSet(availability.name());
        return nodeAvailabilitySet.contains((Object)id);
    }

    public Set<NodeId> getNodesByAvailability(Availability availability) {
        return this.redissonClient.getSet(availability.name());
    }

    public void addNode(NodeStatus node) {
        this.service.merge((Object)node);
    }

    public void removeNode(NodeId id) {
        this.service.delete(NodeStatus.class, new Object[]{id});
    }

    public Optional<NodeStatus> getNode(NodeId id) {
        Optional<NodeStatus> maybeNode = Optional.ofNullable((NodeStatus)this.service.get(NodeStatus.class, (Object)id));
        if (maybeNode.isPresent()) {
            NodeStatus node = maybeNode.get();
            NodeStatus resultNode = new NodeStatus(id, node.getExternalUri(), node.getMaxSessionCount(), node.getSlots(), node.getAvailability(), node.getHeartbeatPeriod(), node.getSessionTimeout(), node.getVersion(), node.getOsInfo());
            return Optional.of(resultNode);
        }
        return maybeNode;
    }

    public void removeAllNodes(Set<NodeId> nodeIds) {
        nodeIds.forEach(this::removeNode);
    }

    public Set<NodeStatus> getNodes(Set<NodeId> nodeIds) {
        return nodeIds.stream().filter(nodeId -> this.getNode((NodeId)nodeId).isPresent()).map(nodeId -> this.getNode((NodeId)nodeId).get()).collect(Collectors.toSet());
    }

    public Set<NodeId> getAllNodes() {
        HashSet<NodeId> nodeIds = new HashSet<NodeId>();
        Iterable allNodeIds = this.service.findIds(NodeStatus.class);
        allNodeIds.forEach(nodeIds::add);
        return nodeIds;
    }
}

