/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;

public class FluentWait<T>
implements Wait<T> {
    protected static final long DEFAULT_SLEEP_TIMEOUT = 500L;
    @Deprecated
    public static final Duration FIVE_HUNDRED_MILLIS = new Duration(500L, TimeUnit.MILLISECONDS);
    private static final java.time.Duration DEFAULT_WAIT_DURATION = java.time.Duration.ofMillis(500L);
    private final T input;
    private final Clock clock;
    private final Sleeper sleeper;
    private java.time.Duration timeout = DEFAULT_WAIT_DURATION;
    private java.time.Duration interval = DEFAULT_WAIT_DURATION;
    private Supplier<String> messageSupplier = () -> null;
    private List<Class<? extends Throwable>> ignoredExceptions = Lists.newLinkedList();

    public FluentWait(T input) {
        this(input, new SystemClock(), Sleeper.SYSTEM_SLEEPER);
    }

    public FluentWait(T input, Clock clock, Sleeper sleeper) {
        this.input = Preconditions.checkNotNull(input);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
    }

    @Deprecated
    public FluentWait<T> withTimeout(long duration, TimeUnit unit) {
        return this.withTimeout(java.time.Duration.of(duration, this.toChronoUnit(unit)));
    }

    public FluentWait<T> withTimeout(java.time.Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public FluentWait<T> withMessage(String message) {
        this.messageSupplier = () -> message;
        return this;
    }

    public FluentWait<T> withMessage(Supplier<String> messageSupplier) {
        this.messageSupplier = messageSupplier;
        return this;
    }

    @Deprecated
    public FluentWait<T> pollingEvery(long duration, TimeUnit unit) {
        return this.pollingEvery(java.time.Duration.of(duration, this.toChronoUnit(unit)));
    }

    public FluentWait<T> pollingEvery(java.time.Duration interval) {
        this.interval = interval;
        return this;
    }

    public <K extends Throwable> FluentWait<T> ignoreAll(Collection<Class<? extends K>> types) {
        this.ignoredExceptions.addAll(types);
        return this;
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> exceptionType) {
        return this.ignoreAll((Collection)ImmutableList.of(exceptionType));
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> firstType, Class<? extends Throwable> secondType) {
        return this.ignoreAll((Collection)ImmutableList.of(firstType, secondType));
    }

    @Override
    public <V> V until(Function<? super T, V> isTrue) {
        long end = this.clock.laterBy(this.timeout.toMillis());
        while (true) {
            Throwable lastException;
            try {
                V value = isTrue.apply(this.input);
                if (value != null && (Boolean.class != value.getClass() || Boolean.TRUE.equals(value))) {
                    return value;
                }
                lastException = null;
            }
            catch (Throwable e) {
                lastException = this.propagateIfNotIgnored(e);
            }
            if (!this.clock.isNowBefore(end)) {
                String message = this.messageSupplier != null ? this.messageSupplier.get() : null;
                String timeoutMessage = String.format("Expected condition failed: %s (tried for %d second(s) with %d milliseconds interval)", message == null ? "waiting for " + isTrue : message, this.timeout.getSeconds(), this.interval.toMillis());
                throw this.timeoutException(timeoutMessage, lastException);
            }
            try {
                this.sleeper.sleep(this.interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private Throwable propagateIfNotIgnored(Throwable e) {
        for (Class<? extends Throwable> ignoredException : this.ignoredExceptions) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        Throwables.throwIfUnchecked((Throwable)e);
        throw new RuntimeException(e);
    }

    protected RuntimeException timeoutException(String message, Throwable lastException) {
        throw new TimeoutException(message, lastException);
    }

    private ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("No ChronoUnit equivalent for " + (Object)((Object)timeUnit));
    }
}

