/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.Wait;

public class FluentWait<T>
implements Wait<T> {
    protected static final long DEFAULT_SLEEP_TIMEOUT = 500L;
    private static final Duration DEFAULT_WAIT_DURATION = Duration.ofMillis(500L);
    private final T input;
    private final Clock clock;
    private final Sleeper sleeper;
    private Duration timeout = DEFAULT_WAIT_DURATION;
    private Duration interval = DEFAULT_WAIT_DURATION;
    private Supplier<String> messageSupplier = () -> null;
    private List<Class<? extends Throwable>> ignoredExceptions = new ArrayList<Class<? extends Throwable>>();

    public FluentWait(T input) {
        this(input, Clock.systemDefaultZone(), Sleeper.SYSTEM_SLEEPER);
    }

    public FluentWait(T input, Clock clock, Sleeper sleeper) {
        this.input = Objects.requireNonNull(input);
        this.clock = Objects.requireNonNull(clock);
        this.sleeper = Objects.requireNonNull(sleeper);
    }

    public FluentWait<T> withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public FluentWait<T> withMessage(String message) {
        this.messageSupplier = () -> message;
        return this;
    }

    public FluentWait<T> withMessage(Supplier<String> messageSupplier) {
        this.messageSupplier = messageSupplier;
        return this;
    }

    public FluentWait<T> pollingEvery(Duration interval) {
        this.interval = interval;
        return this;
    }

    public <K extends Throwable> FluentWait<T> ignoreAll(Collection<Class<? extends K>> types) {
        this.ignoredExceptions.addAll(types);
        return this;
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> exceptionType) {
        return this.ignoreAll((Collection)ImmutableList.of(exceptionType));
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> firstType, Class<? extends Throwable> secondType) {
        return this.ignoreAll((Collection)ImmutableList.of(firstType, secondType));
    }

    @Override
    public <V> V until(Function<? super T, V> isTrue) {
        Instant end = this.clock.instant().plus(this.timeout);
        while (true) {
            Throwable lastException;
            try {
                V value = isTrue.apply(this.input);
                if (value != null && (Boolean.class != value.getClass() || Boolean.TRUE.equals(value))) {
                    return value;
                }
                lastException = null;
            }
            catch (Throwable e) {
                lastException = this.propagateIfNotIgnored(e);
            }
            if (end.isBefore(this.clock.instant())) {
                String message = this.messageSupplier != null ? this.messageSupplier.get() : null;
                String timeoutMessage = String.format("Expected condition failed: %s (tried for %d second(s) with %d milliseconds interval)", message == null ? "waiting for " + isTrue : message, this.timeout.getSeconds(), this.interval.toMillis());
                throw this.timeoutException(timeoutMessage, lastException);
            }
            try {
                this.sleeper.sleep(this.interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private Throwable propagateIfNotIgnored(Throwable e) {
        for (Class<? extends Throwable> ignoredException : this.ignoredExceptions) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        Throwables.throwIfUnchecked((Throwable)e);
        throw new RuntimeException(e);
    }

    protected RuntimeException timeoutException(String message, Throwable lastException) {
        throw new TimeoutException(message, lastException);
    }

    private ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("No ChronoUnit equivalent for " + (Object)((Object)timeUnit));
    }
}

