/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class ChildrenFindingTest
extends AbstractDriverTestCase {
    public void testFindElementByXPath() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"form2"));
        WebElement child = element.findElement(By.xpath((String)"select"));
        MatcherAssert.assertThat((Object)child.getAttribute("id"), (Matcher)Matchers.is((Object)"2"));
    }

    public void testFindElementByXPathWhenNoMatch() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"form2"));
        try {
            element.findElement(By.xpath((String)"select/x"));
        }
        catch (NoSuchElementException e) {
            return;
        }
        ChildrenFindingTest.fail();
    }

    public void testfindElementsByXPath() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"form2"));
        List children = element.findElements(By.xpath((String)"select/option"));
        MatcherAssert.assertThat((Object)children.size(), (Matcher)Matchers.is((Object)8));
        MatcherAssert.assertThat((Object)((WebElement)children.get(0)).getText(), (Matcher)Matchers.is((Object)"One"));
        MatcherAssert.assertThat((Object)((WebElement)children.get(1)).getText(), (Matcher)Matchers.is((Object)"Two"));
    }

    public void testfindElementsByXPathWhenNoMatch() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"form2"));
        List children = element.findElements(By.xpath((String)"select/x"));
        ChildrenFindingTest.assertEquals((int)0, (int)children.size());
    }

    public void testfindElementByName() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"form2"));
        WebElement child = element.findElement(By.name((String)"selectomatic"));
        MatcherAssert.assertThat((Object)child.getAttribute("id"), (Matcher)Matchers.is((Object)"2"));
    }

    public void testfindElementsByName() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"form2"));
        List children = element.findElements(By.name((String)"selectomatic"));
        MatcherAssert.assertThat((Object)children.size(), (Matcher)Matchers.is((Object)2));
    }

    public void testfindElementById() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"form2"));
        WebElement child = element.findElement(By.id((String)"2"));
        MatcherAssert.assertThat((Object)child.getAttribute("name"), (Matcher)Matchers.is((Object)"selectomatic"));
    }

    public void testfindElementByIdWhenMultipleMatchesExist() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.id((String)"test_id_div"));
        WebElement child = element.findElement(By.id((String)"test_id"));
        MatcherAssert.assertThat((Object)child.getText(), (Matcher)Matchers.is((Object)"inside"));
    }

    public void testfindElementByIdWhenNoMatchInContext() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.id((String)"test_id_div"));
        try {
            element.findElement(By.id((String)"test_id_out"));
        }
        catch (NoSuchElementException e) {
            return;
        }
        ChildrenFindingTest.fail();
    }

    public void testfindElementsById() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"form2"));
        List children = element.findElements(By.id((String)"2"));
        MatcherAssert.assertThat((Object)children.size(), (Matcher)Matchers.is((Object)2));
    }

    public void testFindElementByLinkText() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"div1"));
        WebElement child = element.findElement(By.linkText((String)"hello world"));
        MatcherAssert.assertThat((Object)child.getAttribute("name"), (Matcher)Matchers.is((Object)"link1"));
    }

    public void testFindElementsByLinkTest() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"div1"));
        List elements = element.findElements(By.linkText((String)"hello world"));
        ChildrenFindingTest.assertEquals((int)2, (int)elements.size());
        MatcherAssert.assertThat((Object)((WebElement)elements.get(0)).getAttribute("name"), (Matcher)Matchers.is((Object)"link1"));
        MatcherAssert.assertThat((Object)((WebElement)elements.get(1)).getAttribute("name"), (Matcher)Matchers.is((Object)"link2"));
    }

    public void testfindElementsByLinkText() {
        this.driver.get(this.nestedPage);
        WebElement element = this.driver.findElement(By.name((String)"div1"));
        List children = element.findElements(By.linkText((String)"hello world"));
        MatcherAssert.assertThat((Object)children.size(), (Matcher)Matchers.is((Object)2));
    }

    @Ignore(value={Ignore.Driver.IE})
    public void testShouldFindChildElementsByClassName() {
        this.driver.get(this.nestedPage);
        WebElement parent = this.driver.findElement(By.name((String)"classes"));
        WebElement element = parent.findElement(By.className((String)"one"));
        ChildrenFindingTest.assertEquals((String)"Find me", (String)element.getText());
    }

    @Ignore(value={Ignore.Driver.IE})
    public void testShouldFindChildrenByClassName() {
        this.driver.get(this.nestedPage);
        WebElement parent = this.driver.findElement(By.name((String)"classes"));
        List elements = parent.findElements(By.className((String)"one"));
        ChildrenFindingTest.assertEquals((int)2, (int)elements.size());
    }

    public void testShouldFindChildElementsByTagName() {
        this.driver.get(this.nestedPage);
        WebElement parent = this.driver.findElement(By.name((String)"div1"));
        WebElement element = parent.findElement(By.tagName((String)"a"));
        ChildrenFindingTest.assertEquals((String)"link1", (String)element.getAttribute("name"));
    }

    public void testShouldFindChildrenByTagName() {
        this.driver.get(this.nestedPage);
        WebElement parent = this.driver.findElement(By.name((String)"div1"));
        List elements = parent.findElements(By.tagName((String)"a"));
        ChildrenFindingTest.assertEquals((int)2, (int)elements.size());
    }
}

