/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Date;
import junit.framework.TestCase;
import org.openqa.selenium.internal.ReturnedCookie;

public class CookieTest
extends TestCase {
    public void testCanCreateAWellFormedCookie() {
        new ReturnedCookie("Fish", "cod", "", "", null, false);
    }

    public void testShouldThrowAnExceptionWhenTheDomainIsBad() {
        try {
            new ReturnedCookie("Fish", "cod", "127.0.0.-1", null, null, false);
            CookieTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testShouldThrowAnExceptionWhenSemiColonExistsInTheCookieAttribute() {
        try {
            new ReturnedCookie("hi;hi", "value", null, null, null, false);
            CookieTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testShouldThrowAnExceptionTheNameIsNull() {
        try {
            new ReturnedCookie(null, "value", null, null, null, false);
            CookieTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCookiesShouldAllowSecureToBeSet() {
        ReturnedCookie cookie = new ReturnedCookie("name", "value", "", "/", new Date(), true);
        CookieTest.assertTrue((boolean)cookie.isSecure());
    }
}

