/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.WebElement;

public class CorrectEventFiringTest
extends AbstractDriverTestCase {
    @Ignore(value={Ignore.Driver.CHROME}, reason="Webkit bug 22261")
    @JavascriptEnabled
    public void testShouldFireFocusEventWhenClicking() {
        this.driver.get(this.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("focus");
    }

    @JavascriptEnabled
    public void testShouldFireClickEventWhenClicking() {
        this.driver.get(this.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("click");
    }

    @JavascriptEnabled
    public void testShouldFireMouseDownEventWhenClicking() {
        this.driver.get(this.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("mousedown");
    }

    @JavascriptEnabled
    public void testShouldFireMouseUpEventWhenClicking() {
        this.driver.get(this.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("mouseup");
    }

    @Ignore(value={Ignore.Driver.CHROME}, reason="Webkit bug 22261")
    @JavascriptEnabled
    public void testShouldFireEventsInTheRightOrder() {
        this.driver.get(this.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        String text = this.driver.findElement(By.id((String)"result")).getText();
        int lastIndex = -1;
        for (String event : new String[]{"mousedown", "focus", "mouseup", "click"}) {
            int index = text.indexOf(event);
            CorrectEventFiringTest.assertTrue((String)(event + " did not fire at all"), (index != -1 ? 1 : 0) != 0);
            CorrectEventFiringTest.assertTrue((String)(event + " did not fire in the correct order"), (index > lastIndex ? 1 : 0) != 0);
        }
    }

    @JavascriptEnabled
    public void testsShouldIssueMouseDownEvents() {
        this.driver.get(this.javascriptPage);
        this.driver.findElement(By.id((String)"mousedown")).click();
        String result = this.driver.findElement(By.id((String)"result")).getText();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"mouse down"));
    }

    @JavascriptEnabled
    public void testShouldIssueClickEvents() {
        this.driver.get(this.javascriptPage);
        this.driver.findElement(By.id((String)"mouseclick")).click();
        String result = this.driver.findElement(By.id((String)"result")).getText();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"mouse click"));
    }

    @JavascriptEnabled
    public void testShouldIssueMouseUpEvents() {
        this.driver.get(this.javascriptPage);
        this.driver.findElement(By.id((String)"mouseup")).click();
        String result = this.driver.findElement(By.id((String)"result")).getText();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"mouse up"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IPHONE})
    public void testMouseEventsShouldBubbleUpToContainingElements() {
        this.driver.get(this.javascriptPage);
        this.driver.findElement(By.id((String)"child")).click();
        String result = this.driver.findElement(By.id((String)"result")).getText();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"mouse down"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IPHONE})
    public void testShouldEmitOnChangeEventsWhenSelectingElements() {
        this.driver.get(this.javascriptPage);
        WebElement select = this.driver.findElement(By.id((String)"selector"));
        List allOptions = select.findElements(By.tagName((String)"option"));
        String initialTextValue = this.driver.findElement(By.id((String)"result")).getText();
        WebElement foo = (WebElement)allOptions.get(0);
        WebElement bar = (WebElement)allOptions.get(1);
        foo.setSelected();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText(), (Matcher)Matchers.equalTo((Object)initialTextValue));
        bar.setSelected();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText(), (Matcher)Matchers.equalTo((Object)"bar"));
    }

    @JavascriptEnabled
    public void testShouldEmitOnChangeEventsWhenChangingTheStateOfACheckbox() {
        this.driver.get(this.javascriptPage);
        WebElement checkbox = this.driver.findElement(By.id((String)"checkbox"));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText(), (Matcher)Matchers.equalTo((Object)"checkbox thing"));
    }

    @JavascriptEnabled
    public void testShouldEmitClickEventWhenClickingOnATextInputElement() {
        this.driver.get(this.javascriptPage);
        WebElement clicker = this.driver.findElement(By.id((String)"clickField"));
        clicker.click();
        MatcherAssert.assertThat((Object)clicker.getValue(), (Matcher)Matchers.equalTo((Object)"Clicked"));
    }

    @JavascriptEnabled
    public void testClearingAnElementShouldCauseTheOnChangeHandlerToFire() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"clearMe"));
        element.clear();
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"Cleared"));
    }

    private void clickOnElementWhichRecordsEvents() {
        this.driver.findElement(By.id((String)"plainButton")).click();
    }

    private void assertEventFired(String eventName) {
        WebElement result = this.driver.findElement(By.id((String)"result"));
        String text = result.getText();
        CorrectEventFiringTest.assertTrue((String)("No " + eventName + " fired"), (boolean)text.contains(eventName));
    }
}

