/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.WebElement;

public class ElementAttributeTest
extends AbstractDriverTestCase {
    @Ignore(value={Ignore.Driver.IE})
    public void testShouldReturnNullWhenGettingTheValueOfAnAttributeThatIsNotListed() {
        this.driver.get(this.simpleTestPage);
        WebElement head = this.driver.findElement(By.xpath((String)"/html"));
        String attribute = head.getAttribute("cheese");
        MatcherAssert.assertThat((Object)attribute, (Matcher)Matchers.is((Matcher)IsNull.nullValue()));
    }

    public void testShouldReturnEmptyAttributeValuesWhenPresentAndTheValueIsActuallyEmpty() {
        this.driver.get(this.simpleTestPage);
        WebElement body = this.driver.findElement(By.xpath((String)"//body"));
        MatcherAssert.assertThat((Object)body.getAttribute("style"), (Matcher)Matchers.equalTo((Object)""));
    }

    public void testShouldReturnTheValueOfTheDisabledAttrbuteEvenIfItIsMissing() {
        this.driver.get(this.formPage);
        WebElement inputElement = this.driver.findElement(By.xpath((String)"//input[@id='working']"));
        MatcherAssert.assertThat((Object)inputElement.getAttribute("disabled"), (Matcher)Matchers.equalTo((Object)"false"));
    }

    @Ignore(value={Ignore.Driver.IE})
    public void testShouldReturnTheValueOfTheIndexAttrbuteEvenIfItIsMissing() {
        this.driver.get(this.formPage);
        WebElement multiSelect = this.driver.findElement(By.id((String)"multi"));
        List options = multiSelect.findElements(By.tagName((String)"option"));
        MatcherAssert.assertThat((Object)((WebElement)options.get(1)).getAttribute("index"), (Matcher)Matchers.equalTo((Object)"1"));
    }

    public void testShouldIndicateTheElementsThatAreDisabledAreNotEnabled() {
        this.driver.get(this.formPage);
        WebElement inputElement = this.driver.findElement(By.xpath((String)"//input[@id='notWorking']"));
        MatcherAssert.assertThat((Object)inputElement.isEnabled(), (Matcher)Matchers.is((Object)false));
        inputElement = this.driver.findElement(By.xpath((String)"//input[@id='working']"));
        MatcherAssert.assertThat((Object)inputElement.isEnabled(), (Matcher)Matchers.is((Object)true));
    }

    public void testShouldIndicateWhenATextAreaIsDisabled() {
        this.driver.get(this.formPage);
        WebElement textArea = this.driver.findElement(By.xpath((String)"//textarea[@id='notWorkingArea']"));
        MatcherAssert.assertThat((Object)textArea.isEnabled(), (Matcher)Matchers.is((Object)false));
    }

    public void testShouldIndicateWhenASelectIsDisabled() {
        this.driver.get(this.formPage);
        WebElement enabled = this.driver.findElement(By.name((String)"selectomatic"));
        WebElement disabled = this.driver.findElement(By.name((String)"no-select"));
        ElementAttributeTest.assertTrue((boolean)enabled.isEnabled());
        ElementAttributeTest.assertFalse((boolean)disabled.isEnabled());
    }

    public void testShouldReturnTheValueOfCheckedForACheckboxEvenIfItLacksThatAttribute() {
        this.driver.get(this.formPage);
        WebElement checkbox = this.driver.findElement(By.xpath((String)"//input[@id='checky']"));
        MatcherAssert.assertThat((Object)checkbox.getAttribute("checked"), (Matcher)Matchers.equalTo((Object)"false"));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)checkbox.getAttribute("checked"), (Matcher)Matchers.equalTo((Object)"true"));
    }

    public void testShouldReturnTheValueOfSelectedForRadioButtonsEvenIfTheyLackThatAttribute() {
        this.driver.get(this.formPage);
        WebElement neverSelected = this.driver.findElement(By.id((String)"cheese"));
        WebElement initiallyNotSelected = this.driver.findElement(By.id((String)"peas"));
        WebElement initiallySelected = this.driver.findElement(By.id((String)"cheese_and_peas"));
        MatcherAssert.assertThat((Object)neverSelected.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"false"));
        MatcherAssert.assertThat((Object)initiallyNotSelected.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"false"));
        MatcherAssert.assertThat((Object)initiallySelected.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"true"));
        initiallyNotSelected.setSelected();
        MatcherAssert.assertThat((Object)neverSelected.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"false"));
        MatcherAssert.assertThat((Object)initiallyNotSelected.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)initiallySelected.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"false"));
    }

    public void testShouldReturnTheValueOfSelectedForOptionsInSelectsEvenIfTheyLackThatAttribute() {
        this.driver.get(this.formPage);
        WebElement selectBox = this.driver.findElement(By.xpath((String)"//select[@name='selectomatic']"));
        List options = selectBox.findElements(By.tagName((String)"option"));
        WebElement one = (WebElement)options.get(0);
        WebElement two = (WebElement)options.get(1);
        MatcherAssert.assertThat((Object)one.isSelected(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)two.isSelected(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)one.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)two.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"false"));
    }

    public void testShouldReturnValueOfClassAttributeOfAnElement() {
        this.driver.get(this.xhtmlTestPage);
        WebElement heading = this.driver.findElement(By.xpath((String)"//h1"));
        String className = heading.getAttribute("class");
        MatcherAssert.assertThat((Object)className, (Matcher)Matchers.equalTo((Object)"header"));
    }

    public void testShouldReturnTheContentsOfATextAreaAsItsValue() {
        this.driver.get(this.formPage);
        String value = this.driver.findElement(By.id((String)"withText")).getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)"Example text"));
    }

    public void testShouldTreatReadonlyAsAValue() {
        this.driver.get(this.formPage);
        WebElement element = this.driver.findElement(By.name((String)"readonly"));
        String readonly = element.getAttribute("readonly");
        WebElement textInput = this.driver.findElement(By.name((String)"x"));
        String notReadonly = textInput.getAttribute("readonly");
        ElementAttributeTest.assertFalse((boolean)readonly.equals(notReadonly));
    }

    public void testElementEqualityShouldWork() {
        this.driver.get(this.simpleTestPage);
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        WebElement xbody = this.driver.findElement(By.xpath((String)"//body"));
        ElementAttributeTest.assertEquals((Object)body, (Object)xbody);
    }
}

