/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutingJavascriptTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAString() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.xhtmlTestPage);
        Object result = this.executeScript("return document.title;", new Object[0]);
        ExecutingJavascriptTest.assertTrue((boolean)(result instanceof String));
        ExecutingJavascriptTest.assertEquals((Object)"XHTML Test Page", (Object)result);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnALong() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.nestedPage);
        Object result = this.executeScript("return document.getElementsByName('checky').length;", new Object[0]);
        ExecutingJavascriptTest.assertTrue((String)result.getClass().getName(), (boolean)(result instanceof Long));
        ExecutingJavascriptTest.assertTrue(((Long)result > 1L ? 1 : 0) != 0);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAWebElement() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.xhtmlTestPage);
        Object result = this.executeScript("return document.getElementById('id1');", new Object[0]);
        ExecutingJavascriptTest.assertNotNull((Object)result);
        ExecutingJavascriptTest.assertTrue((String)("Expected WebElement, got: " + result.getClass()), (boolean)(result instanceof WebElement));
    }

    @JavascriptEnabled
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnABoolean() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.xhtmlTestPage);
        Object result = this.executeScript("return true;", new Object[0]);
        ExecutingJavascriptTest.assertNotNull((Object)result);
        ExecutingJavascriptTest.assertTrue((boolean)(result instanceof Boolean));
        ExecutingJavascriptTest.assertTrue((boolean)((Boolean)result));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE})
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAnArray() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        ArrayList<Object> expectedResult = new ArrayList<Object>();
        expectedResult.add("zero");
        ArrayList<Boolean> subList = new ArrayList<Boolean>();
        subList.add(true);
        subList.add(false);
        expectedResult.add(subList);
        Object result = this.executeScript("return ['zero', [true, false]];", new Object[0]);
        ExecutingJavascriptTest.assertTrue((String)("result was: " + result + " (" + result.getClass() + ")"), (boolean)(result instanceof List));
        List list = (List)result;
        ExecutingJavascriptTest.assertTrue((boolean)this.compareLists(expectedResult, list));
    }

    private boolean compareLists(List<?> first, List<?> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (first.get(i) instanceof List) {
                if (!(second instanceof List)) {
                    return false;
                }
                if (this.compareLists((List)first.get(i), (List)second.get(i))) continue;
                return false;
            }
            if (first.get(i).equals(second.get(i))) continue;
            return false;
        }
        return true;
    }

    @JavascriptEnabled
    public void testPassingAndReturningALongShouldReturnAWholeNumber() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        Long expectedResult = 1L;
        Object result = this.executeScript("return arguments[0];", expectedResult);
        ExecutingJavascriptTest.assertTrue((String)("Expected result to be an Integer or Long but was a " + result.getClass()), (result instanceof Integer || result instanceof Long ? 1 : 0) != 0);
        ExecutingJavascriptTest.assertEquals((Object)expectedResult, (Object)result);
    }

    @JavascriptEnabled
    public void testPassingAndReturningADoubleShouldReturnADecimal() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        Double expectedResult = 1.2;
        Object result = this.executeScript("return arguments[0];", expectedResult);
        ExecutingJavascriptTest.assertTrue((String)("Expected result to be a Double or Float but was a " + result.getClass()), (result instanceof Float || result instanceof Double ? 1 : 0) != 0);
        ExecutingJavascriptTest.assertEquals((Object)expectedResult, (Object)result);
    }

    @JavascriptEnabled
    public void testShouldThrowAnExceptionWhenTheJavascriptIsBad() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.xhtmlTestPage);
        try {
            this.executeScript("return squiggle();", new Object[0]);
            ExecutingJavascriptTest.fail((String)"Expected an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    public void testShouldBeAbleToCallFunctionsDefinedOnThePage() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        this.executeScript("displayMessage('I like cheese');", new Object[0]);
        String text = this.driver.findElement(By.id((String)"result")).getText();
        ExecutingJavascriptTest.assertEquals((String)"I like cheese", (String)text.trim());
    }

    private Object executeScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.driver).executeScript(script, args);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassAStringAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        String value = (String)this.executeScript("return arguments[0] == 'fish' ? 'fish' : 'not fish';", "fish");
        ExecutingJavascriptTest.assertEquals((String)"fish", (String)value);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassABooleanAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        boolean value = (Boolean)this.executeScript("return arguments[0] == true;", true);
        ExecutingJavascriptTest.assertTrue((boolean)value);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassANumberAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        boolean value = (Boolean)this.executeScript("return arguments[0] == 1 ? true : false;", 1);
        ExecutingJavascriptTest.assertTrue((boolean)value);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassAWebElementAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        WebElement button = this.driver.findElement(By.id((String)"plainButton"));
        String value = (String)this.executeScript("arguments[0]['flibble'] = arguments[0].getAttribute('id'); return arguments[0]['flibble'];", button);
        ExecutingJavascriptTest.assertEquals((String)"plainButton", (String)value);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE})
    public void testShouldBeAbleToPassAnArrayAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        Object[] array = new Object[]{"zero", 1, true, 3.14159};
        long length = (Long)this.executeScript("return arguments[0].length", array);
        ExecutingJavascriptTest.assertEquals((long)array.length, (long)length);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE})
    public void testShouldBeAbleToPassACollectionAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        AbstractCollection collection = new ArrayList<Object>();
        collection.add("Cheddar");
        collection.add("Brie");
        collection.add(7);
        long length = (Long)this.executeScript("return arguments[0].length", collection);
        ExecutingJavascriptTest.assertEquals((long)collection.size(), (long)length);
        collection = new HashSet();
        collection.add("Gouda");
        collection.add("Stilton");
        collection.add("Stilton");
        collection.add(true);
        length = (Long)this.executeScript("return arguments[0].length", collection);
        ExecutingJavascriptTest.assertEquals((long)collection.size(), (long)length);
    }

    @JavascriptEnabled
    public void testShouldThrowAnExceptionIfAnArgumentIsNotValid() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        try {
            this.executeScript("return arguments[0];", this.driver);
            ExecutingJavascriptTest.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassInMoreThanOneArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.javascriptPage);
        String result = (String)this.executeScript("return arguments[0] + arguments[1];", "one", "two");
        ExecutingJavascriptTest.assertEquals((String)"onetwo", (String)result);
    }

    @Ignore(value={Ignore.Driver.CHROME}, reason="Can't execute script in iframe, track crbug 20773")
    @JavascriptEnabled
    public void testShouldBeAbleToGrabTheBodyOfFrameOnceSwitchedTo() {
        this.driver.get(this.richTextPage);
        this.driver.switchTo().frame("editFrame");
        WebElement body = (WebElement)((JavascriptExecutor)this.driver).executeScript("return document.body", new Object[0]);
        ExecutingJavascriptTest.assertEquals((String)"", (String)body.getText());
    }

    @JavascriptEnabled
    public void testJavascriptStringHandlingShouldWorkAsExpected() {
        this.driver.get(this.javascriptPage);
        String value = (String)this.executeScript("return '';", new Object[0]);
        ExecutingJavascriptTest.assertEquals((String)"", (String)value);
        value = (String)this.executeScript("return undefined;", new Object[0]);
        ExecutingJavascriptTest.assertNull((Object)value);
        value = (String)this.executeScript("return ' '", new Object[0]);
        ExecutingJavascriptTest.assertEquals((String)" ", (String)value);
    }
}

