/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NoDriverAfterTest;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.environment.GlobalTestEnvironment;
import org.openqa.selenium.environment.webserver.AppServer;

public class FrameSwitchingTest
extends AbstractDriverTestCase {
    public void testShouldContinueToReferToTheSameFrameOnceItHasBeenSelected() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame(2);
        WebElement checkbox = this.driver.findElement(By.xpath((String)"//input[@name='checky']"));
        checkbox.toggle();
        checkbox.submit();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.xpath((String)"//p")).getText(), (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    public void testShouldAutomaticallyUseTheFirstFrameOnAPage() {
        this.driver.get(this.framesetPage);
        WebElement pageNumber = this.driver.findElement(By.xpath((String)"//span[@id='pageNumber']"));
        MatcherAssert.assertThat((Object)pageNumber.getText().trim(), (Matcher)Matchers.equalTo((Object)"1"));
    }

    public void testShouldFocusOnTheReplacementWhenAFrameFollowsALinkToA_TopTargettedPage() {
        this.driver.get(this.framesetPage);
        this.driver.findElement(By.linkText((String)"top")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
        MatcherAssert.assertThat((Object)this.driver.findElement(By.xpath((String)"/html/head/title")).getText(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
    }

    public void testShouldNotAutomaticallySwitchFocusToAnIFrameWhenAPageContainingThemIsLoaded() {
        this.driver.get(this.iframePage);
        this.driver.findElement(By.id((String)"iframe_page_heading"));
    }

    public void testShouldAllowAUserToSwitchFromAnIframeBackToTheMainContentOfThePage() {
        this.driver.get(this.iframePage);
        this.driver.switchTo().frame(0);
        try {
            this.driver.switchTo().defaultContent();
            this.driver.findElement(By.id((String)"iframe_page_heading"));
        }
        catch (Exception e) {
            FrameSwitchingTest.fail((String)"Should have switched back to main content");
        }
    }

    @Ignore(value={Ignore.Driver.CHROME}, reason="Can't execute script in iframe, track crbug 20773")
    public void testShouldAllowTheUserToSwitchToAnIFrameAndRemainFocusedOnIt() {
        this.driver.get(this.iframePage);
        this.driver.switchTo().frame(0);
        this.driver.findElement(By.id((String)"submitButton")).click();
        String hello = this.driver.findElement(By.id((String)"greeting")).getText();
        MatcherAssert.assertThat((Object)hello, (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    public void testShouldBeAbleToClickInAFrame() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("third");
        this.driver.findElement(By.id((String)"submitButton")).click();
        String hello = this.driver.findElement(By.id((String)"greeting")).getText();
        MatcherAssert.assertThat((Object)hello, (Matcher)Matchers.equalTo((Object)"Success!"));
        this.driver.switchTo().defaultContent();
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.FIREFOX, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE})
    public void testShouldBeAbleToClickInASubFrame() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("sixth.iframe1");
        this.driver.findElement(By.id((String)"submitButton")).click();
        this.driver.switchTo().frame("sixth");
        String hello = this.driver.findElement(By.id((String)"greeting")).getText();
        MatcherAssert.assertThat((Object)hello, (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    public void testShouldBeAbleToSelectAFrameByName() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("second");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"2"));
    }

    @Ignore(value={Ignore.Driver.FIREFOX, Ignore.Driver.IE, Ignore.Driver.HTMLUNIT})
    public void testShouldBeAbleToSelectAFrameByNameWhichIncludesADot() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("seventh.withadot");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"3"));
    }

    public void testShouldSelectChildFramesByUsingADotSeparatedString() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("fourth.child2");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"11"));
    }

    public void testShouldSwitchToChildFramesTreatingNumbersAsIndex() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("fourth.1");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"11"));
    }

    @Ignore(value={Ignore.Driver.FIREFOX})
    public void testShouldSwitchToChildFramesTreatingParentAndChildNumbersAsIndex() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("3.1");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"11"));
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.IE})
    public void testShouldThrowFrameNotFoundExceptionLookingUpSubFramesWithSuperFrameNames() {
        this.driver.get(this.framesetPage);
        try {
            this.driver.switchTo().frame("fourth.second");
            FrameSwitchingTest.fail((String)"Expected NoSuchFrameException");
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    @NoDriverAfterTest
    @Ignore(value={Ignore.Driver.IPHONE})
    public void testClosingTheFinalBrowserWindowShouldNotCauseAnExceptionToBeThrown() {
        this.driver.get(this.simpleTestPage);
        try {
            this.driver.close();
        }
        catch (Exception e) {
            FrameSwitchingTest.fail((String)("This is not expected. " + e.getMessage()));
        }
    }

    public void testShouldBeAbleToFlipToAFrameIdentifiedByItsId() {
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("fifth");
        try {
            this.driver.findElement(By.id((String)"username"));
        }
        catch (NoSuchElementException e) {
            FrameSwitchingTest.fail((String)"Driver did not switch by frame id");
        }
    }

    public void testShouldThrowAnExceptionWhenAFrameCannotBeFound() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.switchTo().frame("Nothing here");
            FrameSwitchingTest.fail((String)"Should not have been able to switch");
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    public void testShouldThrowAnExceptionWhenAFrameCannotBeFoundByIndex() {
        this.driver.get(this.xhtmlTestPage);
        try {
            this.driver.switchTo().frame(27);
            FrameSwitchingTest.fail((String)"Should not have been able to switch");
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    public void testShouldBeAbleToFindElementsInIframesByName() {
        this.driver.get(this.iframePage);
        this.driver.switchTo().frame("iframe1");
        WebElement element = this.driver.findElement(By.name((String)"id-name1"));
        FrameSwitchingTest.assertNotNull((Object)element);
    }

    public void testShouldBeAbleToFindElementsInIframesByXPath() {
        this.driver.get(this.iframePage);
        this.driver.switchTo().frame("iframe1");
        WebElement element = this.driver.findElement(By.xpath((String)"//*[@id = 'changeme']"));
        FrameSwitchingTest.assertNotNull((Object)element);
    }

    public void testGetCurrentUrl() {
        AppServer appServer = GlobalTestEnvironment.get().getAppServer();
        this.driver.get(this.framesetPage);
        this.driver.switchTo().frame("second");
        String url = appServer.whereIs("page/2");
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)(url + "?title=Fish")));
        url = appServer.whereIs("iframes.html");
        this.driver.get(this.iframePage);
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)url));
        url = appServer.whereIs("formPage.html");
        this.driver.switchTo().frame("iframe1");
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)url));
    }
}

