/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class ObjectStateAssumptionsTest
extends AbstractDriverTestCase {
    public void testUninitializedWebDriverDoesNotThrowNPE() {
        try {
            this.variousMethodCallsToCheckAssumptions();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("Assumptions broken for a fresh WebDriver instance", npe);
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    public void testinitializedWebDriverDoesNotThrowNPE() {
        this.driver.get(this.simpleTestPage);
        try {
            this.variousMethodCallsToCheckAssumptions();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("Assumptions broken for WebDriver instance after get() called", npe);
        }
    }

    private void variousMethodCallsToCheckAssumptions() {
        this.driver.getCurrentUrl();
        this.driver.getTitle();
        this.driver.getPageSource();
        By byHtml = By.xpath((String)"//html");
        this.driver.findElement(byHtml);
        this.driver.findElements(byHtml);
    }

    public void testOptionsForUninitializedWebDriver() {
        WebDriver.Options options = this.driver.manage();
        try {
            options.getCookies();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("Assumptions broken for a fresh WebDriver instance", npe);
        }
    }
}

