/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.lang.reflect.Method;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.WebDriver;

public class SnapshotTakingTest
extends AbstractDriverTestCase {
    public void testShouldTakeSnapshotsOfThePage() throws Exception {
        if (!this.isAbleToTakeSnapshots(this.driver)) {
            return;
        }
        this.driver.get(this.simpleTestPage);
        File temp = File.createTempFile("snapshot", "png");
        temp.deleteOnExit();
        this.takeSnapshot(this.driver, temp);
        SnapshotTakingTest.assertTrue((temp.length() > 0L ? 1 : 0) != 0);
    }

    private void takeSnapshot(WebDriver driver, File temp) throws Exception {
        Method method = this.getSnapshotMethod(driver);
        method.invoke((Object)driver, temp);
    }

    private boolean isAbleToTakeSnapshots(WebDriver driver) throws Exception {
        try {
            this.getSnapshotMethod(driver);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Method getSnapshotMethod(WebDriver driver) throws NoSuchMethodException {
        return driver.getClass().getMethod("saveScreenshot", File.class);
    }
}

