/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.environment.GlobalTestEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextHandlingTest
extends AbstractDriverTestCase {
    private String newLine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.newLine = "\n";
    }

    public void testShouldReturnTheTextContentOfASingleElementWithNoChildren() {
        this.driver.get(this.simpleTestPage);
        String selectText = this.driver.findElement(By.id((String)"oneline")).getText();
        MatcherAssert.assertThat((Object)selectText, (Matcher)Matchers.equalTo((Object)"A single line of text"));
        String getText = this.driver.findElement(By.id((String)"oneline")).getText();
        MatcherAssert.assertThat((Object)getText, (Matcher)Matchers.equalTo((Object)"A single line of text"));
    }

    public void testShouldReturnTheEntireTextContentOfChildElements() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"multiline")).getText();
        MatcherAssert.assertThat((Object)text.contains("A div containing"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)text.contains("More than one line of text"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)text.contains("and block level elements"), (Matcher)Matchers.is((Object)true));
    }

    public void testShouldIgnoreScriptElements() {
        this.driver.get(this.javascriptEnhancedForm);
        WebElement labelForUsername = this.driver.findElement(By.id((String)"labelforusername"));
        String text = labelForUsername.getText();
        MatcherAssert.assertThat((Object)labelForUsername.findElements(By.tagName((String)"script")).size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"document.getElementById")));
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.is((Object)"Username:"));
    }

    public void testShouldRepresentABlockLevelElementAsANewline() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"multiline")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.startsWith((String)("A div containing" + this.newLine)));
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.containsString((String)("More than one line of text" + this.newLine)));
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.endsWith((String)"and block level elements"));
    }

    public void testShouldCollapseMultipleWhitespaceCharactersIntoASingleSpace() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"lotsofspaces")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.equalTo((Object)"This line has lots of spaces."));
    }

    public void testShouldTrimText() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"multiline")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.startsWith((String)"A div containing"));
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.endsWith((String)"block level elements"));
    }

    public void testShouldConvertANonBreakingSpaceIntoANormalSpaceCharacter() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"nbsp")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.equalTo((Object)"This line has a non-breaking space"));
    }

    public void testShouldTreatANonBreakingSpaceAsAnyOtherWhitespaceCharacterWhenCollapsingWhitespace() {
        this.driver.get(this.simpleTestPage);
        WebElement element = this.driver.findElement(By.id((String)"nbspandspaces"));
        String text = element.getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.equalTo((Object)"This line has a non-breaking space and spaces"));
    }

    public void testHavingInlineElementsShouldNotAffectHowTextIsReturned() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"inline")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.equalTo((Object)"This line has text within elements that are meant to be displayed inline"));
    }

    public void testShouldReturnTheEntireTextOfInlineElements() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"span")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.equalTo((Object)"An inline element"));
    }

    public void testShouldBeAbleToSetMoreThanOneLineOfTextInATextArea() {
        this.driver.get(this.formPage);
        WebElement textarea = this.driver.findElement(By.id((String)"withText"));
        textarea.clear();
        String expectedText = "I like cheese" + this.newLine + this.newLine + "It's really nice";
        textarea.sendKeys(new CharSequence[]{expectedText});
        String seenText = textarea.getValue();
        MatcherAssert.assertThat((Object)seenText, (Matcher)Matchers.equalTo((Object)expectedText));
    }

    public void testShouldBeAbleToEnterDatesAfterFillingInOtherValuesFirst() {
        this.driver.get(this.formPage);
        WebElement input = this.driver.findElement(By.id((String)"working"));
        String expectedValue = "10/03/2007 to 30/07/1993";
        input.sendKeys(new CharSequence[]{expectedValue});
        String seenValue = input.getValue();
        MatcherAssert.assertThat((Object)seenValue, (Matcher)Matchers.equalTo((Object)expectedValue));
    }

    public void testShouldReturnEmptyStringWhenTextIsOnlySpaces() {
        this.driver.get(this.xhtmlTestPage);
        String text = this.driver.findElement(By.id((String)"spaces")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.equalTo((Object)""));
    }

    public void testShouldReturnEmptyStringWhenTextIsEmpty() {
        this.driver.get(this.xhtmlTestPage);
        String text = this.driver.findElement(By.id((String)"empty")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.equalTo((Object)""));
    }

    public void testShouldReturnEmptyStringWhenTagIsSelfClosing() {
        this.driver.get(this.xhtmlTestPage);
        String text = this.driver.findElement(By.id((String)"self-closed")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.equalTo((Object)""));
    }

    public void testShouldHandleSiblingBlockLevelElements() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"twoblocks")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.is((Object)("Some text" + this.newLine + "Some more text")));
    }

    @Ignore(value={Ignore.Driver.FIREFOX, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.CHROME})
    public void testShouldHandleNestedBlockLevelElements() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"nestedblocks")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.is((Object)("Cheese" + this.newLine + "Some text" + this.newLine + "Some more text" + this.newLine + "and also" + this.newLine + "Brie")));
    }

    public void testShouldHandleWhitespaceInInlineElements() {
        this.driver.get(this.simpleTestPage);
        String text = this.driver.findElement(By.id((String)"inlinespan")).getText();
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.is((Object)"line has text"));
    }

    public void testReadALargeAmountOfData() {
        this.driver.get(GlobalTestEnvironment.get().getAppServer().whereIs("macbeth.html"));
        String source = this.driver.getPageSource().trim().toLowerCase();
        MatcherAssert.assertThat((Object)source.endsWith("</html>"), (Matcher)Matchers.is((Object)true));
    }

    public void testGetTextWithLineBreakForInlineElement() {
        this.driver.get(this.simpleTestPage);
        WebElement label = this.driver.findElement(By.id((String)"label1"));
        String labelText = label.getText();
        MatcherAssert.assertThat((Object)labelText, this.matchesPattern("foo[\\n\\r]+bar"));
    }

    private Matcher<String> matchesPattern(String javaRegex) {
        final Pattern pattern = Pattern.compile(javaRegex);
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String s) {
                return pattern.matcher(s).matches();
            }

            public void describeTo(Description description) {
                description.appendText("a string matching the pattern " + pattern);
            }
        };
    }

    @JavascriptEnabled
    public void testShouldOnlyIncludeVisibleText() {
        this.driver.get(this.javascriptPage);
        String empty = this.driver.findElement(By.id((String)"suppressedParagraph")).getText();
        String explicit = this.driver.findElement(By.id((String)"outer")).getText();
        TextHandlingTest.assertEquals((String)"", (String)empty);
        TextHandlingTest.assertEquals((String)"sub-element that is explicitly visible", (String)explicit);
    }
}

